/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.AbstractVirtualRecordSampleByCursor;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.ObjList;

class SampleByFillNoneRecordCursor
extends AbstractVirtualRecordSampleByCursor {
    private final RecordSink keyMapSink;
    private final Map map;
    private final RecordCursor mapCursor;
    private boolean isOpen;

    public SampleByFillNoneRecordCursor(Map map, RecordSink keyMapSink, ObjList<GroupByFunction> groupByFunctions, GroupByFunctionsUpdater groupByFunctionsUpdater, ObjList<Function> recordFunctions, int timestampIndex, TimestampSampler timestampSampler, Function timezoneNameFunc, int timezoneNameFuncPos, Function offsetFunc, int offsetFuncPos) {
        super(recordFunctions, timestampIndex, timestampSampler, groupByFunctions, groupByFunctionsUpdater, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos);
        this.map = map;
        this.keyMapSink = keyMapSink;
        this.record.of(map.getRecord());
        this.mapCursor = map.getCursor();
        this.isOpen = true;
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.map.close();
            super.close();
            this.isOpen = false;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.mapCursor.hasNext()) {
            return true;
        }
        if (this.baseRecord == null) {
            return false;
        }
        this.map.clear();
        this.sampleLocalEpoch = this.localEpoch;
        long next = this.timestampSampler.nextTimestamp(this.localEpoch);
        do {
            long timestamp;
            if ((timestamp = this.getBaseRecordTimestamp()) < next) {
                this.adjustDSTInFlight(timestamp - this.tzOffset);
                MapKey key = this.map.withKey();
                this.keyMapSink.copy(this.baseRecord, key);
                MapValue value = key.createValue();
                if (value.isNew()) {
                    this.groupByFunctionsUpdater.updateNew(value, this.baseRecord);
                } else {
                    this.groupByFunctionsUpdater.updateExisting(value, this.baseRecord);
                }
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                continue;
            }
            if ((timestamp = this.adjustDST(timestamp, null, next)) == Long.MIN_VALUE) continue;
            this.nextSamplePeriod(timestamp);
            return this.createMapCursor();
        } while (this.base.hasNext());
        this.baseRecord = null;
        return this.createMapCursor();
    }

    @Override
    public void of(RecordCursor base, SqlExecutionContext executionContext) throws SqlException {
        super.of(base, executionContext);
        if (!this.isOpen) {
            this.map.reopen();
            this.isOpen = true;
        }
    }

    @Override
    public void toTop() {
        super.toTop();
        if (this.base.hasNext()) {
            this.baseRecord = this.base.getRecord();
            this.map.clear();
        }
    }

    private boolean createMapCursor() {
        this.map.getCursor();
        return this.mapHasNext();
    }

    private boolean mapHasNext() {
        return this.mapCursor.hasNext();
    }

    @Override
    protected void updateValueWhenClockMovesBack(MapValue value) {
        MapKey key = this.map.withKey();
        this.keyMapSink.copy(this.baseRecord, key);
        super.updateValueWhenClockMovesBack(key.createValue());
    }
}

