/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.sql.InsertOperation;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cutlass.text.TextLoader;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.griffin.engine.ops.DoneOperationFuture;
import io.questdb.griffin.engine.ops.OperationDispatcher;
import io.questdb.griffin.engine.ops.UpdateOperation;
import io.questdb.mp.SCSequence;
import io.questdb.std.Chars;
import org.jetbrains.annotations.Nullable;

public class CompiledQueryImpl
implements CompiledQuery {
    private final OperationDispatcher<AlterOperation> alterOperationDispatcher;
    private final DoneOperationFuture doneFuture = new DoneOperationFuture();
    private final OperationDispatcher<UpdateOperation> updateOperationDispatcher;
    private long affectedRowsCount;
    private AlterOperation alterOp;
    private InsertOperation insertOp;
    private RecordCursorFactory recordCursorFactory;
    private SqlExecutionContext sqlExecutionContext;
    private String sqlStatement;
    private CharSequence statementName;
    private TextLoader textLoader;
    private short type;
    private UpdateOperation updateOperation;

    public CompiledQueryImpl(CairoEngine engine) {
        this.updateOperationDispatcher = new OperationDispatcher<UpdateOperation>(engine, "sync 'UPDATE' execution"){

            @Override
            protected long apply(UpdateOperation operation, TableWriterAPI writerAPI) {
                return writerAPI.apply(operation);
            }
        };
        this.alterOperationDispatcher = new OperationDispatcher<AlterOperation>(engine, "Alter table execute"){

            @Override
            protected long apply(AlterOperation operation, TableWriterAPI writerAPI) {
                return writerAPI.apply(operation, true);
            }
        };
    }

    @Override
    public OperationFuture execute(SCSequence eventSubSeq) throws SqlException {
        return this.execute(this.sqlExecutionContext, eventSubSeq, true);
    }

    @Override
    public OperationFuture execute(SqlExecutionContext sqlExecutionContext, SCSequence eventSubSeq, boolean closeOnDone) throws SqlException {
        switch (this.type) {
            case 2: {
                return this.insertOp.execute(sqlExecutionContext);
            }
            case 14: {
                this.updateOperation.withSqlStatement(this.sqlStatement);
                return this.updateOperationDispatcher.execute(this.updateOperation, sqlExecutionContext, eventSubSeq, closeOnDone);
            }
            case 4: {
                this.alterOp.withSqlStatement(this.sqlStatement);
                return this.alterOperationDispatcher.execute(this.alterOp, sqlExecutionContext, eventSubSeq, closeOnDone);
            }
        }
        return this.doneFuture.of(0L);
    }

    @Override
    public long getAffectedRowsCount() {
        return this.affectedRowsCount;
    }

    @Override
    public AlterOperation getAlterOperation() {
        return this.alterOp;
    }

    @Override
    public InsertOperation getInsertOperation() {
        return this.insertOp;
    }

    @Override
    public RecordCursorFactory getRecordCursorFactory() {
        return this.recordCursorFactory;
    }

    @Override
    public String getSqlStatement() {
        return this.sqlStatement;
    }

    @Override
    public CharSequence getStatementName() {
        return this.statementName;
    }

    @Override
    public TextLoader getTextLoader() {
        return this.textLoader;
    }

    @Override
    public short getType() {
        return this.type;
    }

    @Override
    public UpdateOperation getUpdateOperation() {
        return this.updateOperation;
    }

    public CompiledQuery of(short type) {
        return this.of(type, null);
    }

    public CompiledQuery ofLock() {
        this.type = (short)15;
        return this;
    }

    public CompiledQuery ofTableResume() {
        this.type = (short)25;
        return this;
    }

    public CompiledQuery ofUnlock() {
        this.type = (short)16;
        return this;
    }

    public CompiledQuery ofUpdate(UpdateOperation updateOperation) {
        this.updateOperation = updateOperation;
        this.type = (short)14;
        return this;
    }

    @Override
    public CompiledQueryImpl withContext(SqlExecutionContext sqlExecutionContext) {
        this.sqlExecutionContext = sqlExecutionContext;
        return this;
    }

    @Override
    public void withSqlStatement(String sqlStatement) {
        this.sqlStatement = sqlStatement;
    }

    private CompiledQuery of(short type, RecordCursorFactory factory) {
        this.type = type;
        this.recordCursorFactory = factory;
        this.affectedRowsCount = -1L;
        return this;
    }

    CompiledQuery of(RecordCursorFactory recordCursorFactory) {
        return this.of((short)1, recordCursorFactory);
    }

    CompiledQuery ofAlter(AlterOperation statement) {
        this.of((short)4);
        this.alterOp = statement;
        return this;
    }

    CompiledQuery ofBackupTable() {
        return this.of((short)13);
    }

    CompiledQuery ofBegin() {
        return this.of((short)18);
    }

    CompiledQuery ofCommit() {
        return this.of((short)19);
    }

    CompiledQuery ofCopyLocal(@Nullable RecordCursorFactory factory) {
        this.type = (short)8;
        this.recordCursorFactory = factory;
        this.affectedRowsCount = -1L;
        return this;
    }

    CompiledQuery ofCopyRemote(TextLoader textLoader) {
        this.textLoader = textLoader;
        return this.of((short)11);
    }

    CompiledQuery ofCreateTable() {
        return this.of((short)9);
    }

    CompiledQuery ofCreateTableAsSelect(long affectedRowsCount) {
        this.of((short)21);
        this.affectedRowsCount = affectedRowsCount;
        return this;
    }

    CompiledQuery ofDeallocate(CharSequence statementName) {
        this.statementName = Chars.toString(statementName);
        return this.of((short)24);
    }

    CompiledQuery ofDrop() {
        return this.of((short)7);
    }

    CompiledQuery ofExplain(RecordCursorFactory recordCursorFactory) {
        return this.of((short)25, recordCursorFactory);
    }

    CompiledQuery ofInsert(InsertOperation insertOperation) {
        this.insertOp = insertOperation;
        return this.of((short)2);
    }

    CompiledQuery ofInsertAsSelect(long affectedRowsCount) {
        this.of((short)10);
        this.affectedRowsCount = affectedRowsCount;
        return this;
    }

    CompiledQuery ofRenameTable() {
        return this.of((short)12);
    }

    CompiledQuery ofRepair() {
        return this.of((short)5);
    }

    CompiledQuery ofRollback() {
        return this.of((short)20);
    }

    CompiledQuery ofSet() {
        return this.of((short)6);
    }

    CompiledQuery ofSnapshotComplete() {
        return this.of((short)23);
    }

    CompiledQuery ofSnapshotPrepare() {
        return this.of((short)22);
    }

    CompiledQuery ofTruncate() {
        return this.of((short)3);
    }

    CompiledQuery ofVacuum() {
        return this.of((short)17);
    }
}

