/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.udp;

import io.questdb.cutlass.line.LineChannel;
import io.questdb.cutlass.line.LineSenderException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.NetworkFacade;

public final class UdpLineChannel
implements LineChannel {
    private static final Log LOG = LogFactory.getLog(UdpLineChannel.class);
    private final int fd;
    private final NetworkFacade nf;
    private final long sockaddr;

    public UdpLineChannel(NetworkFacade nf, int interfaceIPv4Address, int sendToAddress, int port, int ttl) {
        this.nf = nf;
        this.fd = nf.socketUdp();
        if (this.fd == -1) {
            throw new LineSenderException("could not create UDP socket").errno(nf.errno());
        }
        this.sockaddr = nf.sockaddr(sendToAddress, port);
        if (nf.setMulticastInterface(this.fd, interfaceIPv4Address) != 0) {
            int errno = nf.errno();
            this.close();
            throw new LineSenderException("could not bind ").put("[ip=").appendIPv4(interfaceIPv4Address).put("]").errno(errno);
        }
        if (nf.setMulticastTtl(this.fd, ttl) != 0) {
            int errno = nf.errno();
            this.close();
            throw new LineSenderException("could not set ttl ").put("[fd=").put(this.fd).put(", ttl=").put(ttl).put("]").errno(errno);
        }
    }

    @Override
    public void close() {
        if (this.nf.close(this.fd) != 0) {
            LOG.error().$("could not close network socket [fd=").$(this.fd).$(", errno=").$(this.nf.errno()).$(']').$();
        }
        this.nf.freeSockAddr(this.sockaddr);
    }

    @Override
    public int errno() {
        return this.nf.errno();
    }

    @Override
    public int receive(long ptr, int len) {
        throw new UnsupportedOperationException("Udp channel does not support receive()");
    }

    @Override
    public void send(long ptr, int len) {
        if (this.nf.sendTo(this.fd, ptr, len, this.sockaddr) != len) {
            throw new LineSenderException("send error").errno(this.nf.errno());
        }
    }
}

