/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.client;

import io.questdb.cutlass.line.LineChannel;
import io.questdb.cutlass.line.LineSenderException;
import io.questdb.cutlass.line.LineTcpSender;
import io.questdb.cutlass.line.tcp.AuthDb;
import io.questdb.cutlass.line.tcp.DelegatingTlsChannel;
import io.questdb.cutlass.line.tcp.PlainTcpLineChannel;
import io.questdb.network.NetworkFacade;
import io.questdb.network.NetworkFacadeImpl;
import io.questdb.std.Chars;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import java.io.Closeable;
import java.security.PrivateKey;
import javax.security.auth.DestroyFailedException;

public interface Sender
extends Closeable {
    public static LineSenderBuilder builder() {
        return new LineSenderBuilder();
    }

    public void at(long var1);

    public void atNow();

    public Sender boolColumn(CharSequence var1, boolean var2);

    @Override
    public void close();

    public Sender doubleColumn(CharSequence var1, double var2);

    public void flush();

    public Sender longColumn(CharSequence var1, long var2);

    public Sender stringColumn(CharSequence var1, CharSequence var2);

    public Sender symbol(CharSequence var1, CharSequence var2);

    public Sender table(CharSequence var1);

    public Sender timestampColumn(CharSequence var1, long var2);

    public static final class LineSenderBuilder {
        private static final byte BUFFER_CAPACITY_DEFAULT = 0;
        private static final int DEFAULT_BUFFER_CAPACITY = 65536;
        private static final int DEFAULT_PORT = 9009;
        private static final int MIN_BUFFER_SIZE_FOR_AUTH = 513;
        private static final byte PORT_DEFAULT = 0;
        private int bufferCapacity = 0;
        private String host;
        private String keyId;
        private int port = 0;
        private PrivateKey privateKey;
        private boolean shouldDestroyPrivKey;
        private boolean tlsEnabled;
        private TlsValidationMode tlsValidationMode = TlsValidationMode.DEFAULT;
        private char[] trustStorePassword;
        private String trustStorePath;

        private LineSenderBuilder() {
        }

        public LineSenderBuilder address(CharSequence address) {
            if (this.host != null) {
                throw new LineSenderException("server address is already configured ").put("[configured-address=").put(this.host).put("]");
            }
            if (address == null || address.length() == 0) {
                throw new LineSenderException("address cannot be empty nor null");
            }
            int portIndex = Chars.indexOf(address, ':');
            if (portIndex + 1 == address.length()) {
                throw new LineSenderException("address cannot ends with : ").put("[address=").put(address).put("]");
            }
            if (portIndex != -1) {
                if (this.port != 0) {
                    throw new LineSenderException("address contains a port, but a port was already configured ").put("[address=").put(address).put(", configured-port=").put(this.port).put("]");
                }
                this.host = address.subSequence(0, portIndex).toString();
                try {
                    this.port = Numbers.parseInt(address, portIndex + 1, address.length());
                }
                catch (NumericException e) {
                    throw new LineSenderException("cannot parse port from address ", e).put("[address=").put(address).put("]");
                }
            } else {
                this.host = address.toString();
            }
            return this;
        }

        public AdvancedTlsSettings advancedTls() {
            if (this.trustStorePath != null) {
                throw new LineSenderException("custom trust store was already configured ").put("[configured-path=").put(this.trustStorePath).put("]");
            }
            if (this.tlsValidationMode == TlsValidationMode.INSECURE) {
                throw new LineSenderException("TLS validation was already disabled");
            }
            return new AdvancedTlsSettings();
        }

        public LineSenderBuilder bufferCapacity(int bufferCapacity) {
            if (this.bufferCapacity != 0) {
                throw new LineSenderException("buffer capacity was already configured ").put("[configured-capacity=").put(this.bufferCapacity).put("]");
            }
            this.bufferCapacity = bufferCapacity;
            return this;
        }

        public Sender build() {
            LineTcpSender sender;
            this.configureDefaults();
            this.validateParameters();
            NetworkFacade nf = NetworkFacadeImpl.INSTANCE;
            LineChannel channel = new PlainTcpLineChannel(nf, this.host, this.port, this.bufferCapacity * 2);
            if (this.tlsEnabled) {
                DelegatingTlsChannel tlsChannel;
                assert (this.trustStorePath == null == (this.trustStorePassword == null));
                try {
                    tlsChannel = new DelegatingTlsChannel(channel, this.trustStorePath, this.trustStorePassword, this.tlsValidationMode, this.host);
                }
                catch (Throwable t) {
                    channel.close();
                    throw LineSenderBuilder.rethrow(t);
                }
                channel = tlsChannel;
            }
            try {
                sender = new LineTcpSender(channel, this.bufferCapacity);
            }
            catch (Throwable t) {
                channel.close();
                throw LineSenderBuilder.rethrow(t);
            }
            if (this.privateKey != null) {
                try {
                    sender.authenticate(this.keyId, this.privateKey);
                }
                catch (Throwable t) {
                    sender.close();
                    throw LineSenderBuilder.rethrow(t);
                }
                finally {
                    if (this.shouldDestroyPrivKey) {
                        try {
                            this.privateKey.destroy();
                        }
                        catch (DestroyFailedException t) {}
                    }
                }
            }
            return sender;
        }

        public AuthBuilder enableAuth(String keyId) {
            if (this.keyId != null) {
                throw new LineSenderException("authentication keyId was already configured ").put("[configured-keyId=").put(this.keyId).put("]");
            }
            this.keyId = keyId;
            return new AuthBuilder();
        }

        public LineSenderBuilder enableTls() {
            if (this.tlsEnabled) {
                throw new LineSenderException("tls was already enabled");
            }
            this.tlsEnabled = true;
            return this;
        }

        public LineSenderBuilder port(int port) {
            if (this.port != 0) {
                throw new LineSenderException("post is already configured ").put("[configured-port=").put(port).put("]");
            }
            this.port = port;
            return this;
        }

        private static RuntimeException rethrow(Throwable t) {
            if (t instanceof LineSenderException) {
                throw (LineSenderException)t;
            }
            throw new LineSenderException(t);
        }

        private void configureDefaults() {
            if (this.bufferCapacity == 0) {
                this.bufferCapacity = 65536;
            }
            if (this.port == 0) {
                this.port = 9009;
            }
        }

        private void validateParameters() {
            if (this.host == null) {
                throw new LineSenderException("questdb server address not set");
            }
            if (!this.tlsEnabled && this.trustStorePath != null) {
                throw new LineSenderException("custom trust store configured, but TLS was not enabled ").put("[configured-path=").put(this.trustStorePath).put("]");
            }
            if (!this.tlsEnabled && this.tlsValidationMode != TlsValidationMode.DEFAULT) {
                throw new LineSenderException("TSL validation disabled, but TLS was not enabled");
            }
            if (this.keyId != null && this.bufferCapacity < 513) {
                throw new LineSenderException("Requested buffer too small ").put("[minimal-capacity=").put(513L).put(", requested-capacity=").put(this.bufferCapacity).put("]");
            }
        }

        static /* synthetic */ char[] access$202(LineSenderBuilder x0, char[] x1) {
            x0.trustStorePassword = x1;
            return x1;
        }

        public class AuthBuilder {
            public LineSenderBuilder authToken(String token) {
                try {
                    LineSenderBuilder.this.privateKey = AuthDb.importPrivateKey(token);
                }
                catch (IllegalArgumentException e) {
                    throw new LineSenderException("could not import token", e);
                }
                LineSenderBuilder.this.shouldDestroyPrivKey = true;
                return LineSenderBuilder.this;
            }

            public LineSenderBuilder privateKey(PrivateKey privateKey) {
                LineSenderBuilder.this.privateKey = privateKey;
                return LineSenderBuilder.this;
            }
        }

        public class AdvancedTlsSettings {
            public LineSenderBuilder customTrustStore(String trustStorePath, char[] trustStorePassword) {
                LineSenderBuilder.this.trustStorePath = trustStorePath;
                LineSenderBuilder.access$202(LineSenderBuilder.this, trustStorePassword);
                return LineSenderBuilder.this;
            }

            public LineSenderBuilder disableCertificateValidation() {
                LineSenderBuilder.this.tlsValidationMode = TlsValidationMode.INSECURE;
                return LineSenderBuilder.this;
            }
        }
    }

    public static enum TlsValidationMode {
        DEFAULT,
        INSECURE;

    }
}

