/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal.seq;

import io.questdb.cairo.BinaryAlterSerializer;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.IDGenerator;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.wal.seq.EmptyOperationCursor;
import io.questdb.cairo.wal.seq.SequencerMetadata;
import io.questdb.cairo.wal.seq.SequencerMetadataService;
import io.questdb.cairo.wal.seq.TableMetadataChange;
import io.questdb.cairo.wal.seq.TableMetadataChangeLog;
import io.questdb.cairo.wal.seq.TableRecordMetadataSink;
import io.questdb.cairo.wal.seq.TableSequencer;
import io.questdb.cairo.wal.seq.TableTransactionLog;
import io.questdb.cairo.wal.seq.TransactionLogCursor;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.SimpleReadWriteLock;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import java.util.concurrent.locks.ReadWriteLock;
import org.jetbrains.annotations.NotNull;

public class TableSequencerImpl
implements TableSequencer {
    private static final Log LOG = LogFactory.getLog(TableSequencerImpl.class);
    private static final BinaryAlterSerializer alterCommandWalFormatter = new BinaryAlterSerializer();
    private final EmptyOperationCursor emptyOperationCursor = new EmptyOperationCursor();
    private final CairoEngine engine;
    private final FilesFacade ff;
    private final SequencerMetadata metadata;
    private final MicrosecondClock microClock;
    private final SequencerMetadataService metadataSvc;
    private final int mkDirMode;
    private final Path path;
    private final int rootLen;
    private final ReadWriteLock schemaLock = new SimpleReadWriteLock();
    private final TableTransactionLog tableTransactionLog;
    private final IDGenerator walIdGenerator;
    private volatile boolean closed = false;
    private boolean distressed;
    private TableToken tableToken;

    TableSequencerImpl(CairoEngine engine, TableToken tableToken) {
        this.engine = engine;
        this.tableToken = tableToken;
        CairoConfiguration configuration = engine.getConfiguration();
        FilesFacade ff = configuration.getFilesFacade();
        try {
            this.path = new Path();
            this.path.of(configuration.getRoot()).concat(tableToken.getDirName()).concat("txn_seq");
            this.rootLen = this.path.length();
            this.ff = ff;
            this.mkDirMode = configuration.getMkDirMode();
            this.metadata = new SequencerMetadata(ff);
            this.metadataSvc = new SequencerMetadataService(this.metadata, tableToken);
            this.walIdGenerator = new IDGenerator(configuration, "_wal_index.d");
            this.tableTransactionLog = new TableTransactionLog(ff);
            this.microClock = engine.getConfiguration().getMicrosecondClock();
        }
        catch (Throwable th) {
            LOG.critical().$("could not create sequencer [name=").utf8(tableToken.getDirName()).$(", error=").$(th.getMessage()).I$();
            this.closeLocked();
            throw th;
        }
    }

    public boolean checkClose() {
        if (!this.closed) {
            this.schemaLock.writeLock().lock();
            try {
                boolean bl = this.closeLocked();
                return bl;
            }
            finally {
                this.schemaLock.writeLock().unlock();
            }
        }
        return false;
    }

    @Override
    public void close() {
        this.checkClose();
    }

    @Override
    public void dropTable() {
        this.checkDropped();
        this.tableTransactionLog.addEntry(this.getStructureVersion(), -2, 0, 0, this.microClock.getTicks());
        this.metadata.dropTable();
        this.engine.notifyWalTxnCommitted(this.tableToken, Long.MAX_VALUE);
    }

    @Override
    public TableMetadataChangeLog getMetadataChangeLog(long structureVersionLo) {
        this.checkDropped();
        if (this.metadata.getStructureVersion() == structureVersionLo) {
            return this.emptyOperationCursor.of(this.tableToken);
        }
        return this.tableTransactionLog.getTableMetadataChangeLog(this.tableToken, structureVersionLo, alterCommandWalFormatter);
    }

    @Override
    public int getNextWalId() {
        return (int)this.walIdGenerator.getNextId();
    }

    @Override
    public long getStructureVersion() {
        return this.metadata.getStructureVersion();
    }

    @Override
    public int getTableId() {
        return this.metadata.getTableId();
    }

    @Override
    public long getTableMetadata(@NotNull TableRecordMetadataSink sink) {
        int columnCount = this.metadata.getColumnCount();
        int timestampIndex = this.metadata.getTimestampIndex();
        int compressedTimestampIndex = -1;
        sink.clear();
        int compressedColumnCount = 0;
        for (int i = 0; i < columnCount; ++i) {
            int columnType = this.metadata.getColumnType(i);
            sink.addColumn((String)this.metadata.getColumnName(i), columnType, this.metadata.isColumnIndexed(i), this.metadata.getIndexValueBlockCapacity(i), this.metadata.isSymbolTableStatic(i), i);
            if (columnType <= -1) continue;
            if (i == timestampIndex) {
                compressedTimestampIndex = compressedColumnCount;
            }
            ++compressedColumnCount;
        }
        sink.of(this.tableToken, this.metadata.getTableId(), timestampIndex, compressedTimestampIndex, this.metadata.isSuspended(), this.metadata.getStructureVersion(), compressedColumnCount);
        return this.tableTransactionLog.lastTxn();
    }

    public TableToken getTableToken() {
        return this.tableToken;
    }

    @Override
    public TransactionLogCursor getTransactionLogCursor(long seqTxn) {
        this.checkDropped();
        return this.tableTransactionLog.getCursor(seqTxn);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isDistressed() {
        return this.distressed;
    }

    public boolean isDropped() {
        return this.metadata.isDropped();
    }

    @Override
    public boolean isSuspended() {
        return this.metadata.isSuspended();
    }

    @Override
    public long lastTxn() {
        return this.tableTransactionLog.lastTxn();
    }

    @Override
    public long nextStructureTxn(long expectedStructureVersion, TableMetadataChange change) {
        long txn;
        assert (!this.closed);
        this.checkDropped();
        try {
            if (this.metadata.getStructureVersion() == expectedStructureVersion) {
                this.tableTransactionLog.beginMetadataChangeEntry(expectedStructureVersion + 1L, alterCommandWalFormatter, change, this.microClock.getTicks());
                AlterOperation deserializedAlter = this.tableTransactionLog.readTableMetadataChangeLog(expectedStructureVersion, alterCommandWalFormatter);
                this.applyToMetadata(deserializedAlter);
                if (this.metadata.getStructureVersion() != expectedStructureVersion + 1L) {
                    throw CairoException.critical(0).put("applying structure change to WAL table failed [table=").put(this.tableToken.getDirName()).put(", oldVersion: ").put(expectedStructureVersion).put(", newVersion: ").put(this.metadata.getStructureVersion()).put(']');
                }
            } else {
                return Long.MIN_VALUE;
            }
            this.metadata.syncToDisk();
            txn = this.tableTransactionLog.endMetadataChangeEntry();
        }
        catch (Throwable th) {
            this.distressed = true;
            LOG.critical().$("could not apply structure change to WAL table sequencer [table=").utf8(this.tableToken.getDirName()).$(", error=").$(th.getMessage()).I$();
            throw th;
        }
        if (!this.metadata.isSuspended()) {
            this.engine.notifyWalTxnCommitted(this.tableToken, txn);
        }
        return txn;
    }

    @Override
    public long nextTxn(long expectedStructureVersion, int walId, int segmentId, int segmentTxn) {
        long txn;
        assert (!this.closed);
        this.checkDropped();
        try {
            if (this.metadata.getStructureVersion() != expectedStructureVersion) {
                return Long.MIN_VALUE;
            }
            txn = this.nextTxn(walId, segmentId, segmentTxn);
        }
        catch (Throwable th) {
            this.distressed = true;
            LOG.critical().$("could not apply transaction to WAL table sequencer [table=").utf8(this.tableToken.getDirName()).$(", error=").$(th.getMessage()).I$();
            throw th;
        }
        if (!this.metadata.isSuspended()) {
            this.engine.notifyWalTxnCommitted(this.tableToken, txn);
        }
        return txn;
    }

    public void open() {
        try {
            this.walIdGenerator.open(this.path);
            this.metadata.open(this.path, this.rootLen);
            this.tableTransactionLog.open(this.path);
        }
        catch (Throwable th) {
            LOG.critical().$("could not open sequencer [name=").utf8(this.tableToken.getDirName()).$(", path=").$(this.path).$(", error=").$(th.getMessage()).I$();
            this.closeLocked();
            throw th;
        }
    }

    @Override
    public void rename(TableToken newTableToken) {
        this.checkDropped();
        this.tableToken = newTableToken;
        this.metadata.updateTableToken(newTableToken);
    }

    @Override
    public void resumeTable() {
        this.metadata.resumeTable();
        this.engine.notifyWalTxnCommitted(this.tableToken, Long.MAX_VALUE);
    }

    public void setDistressed() {
        this.distressed = true;
    }

    @Override
    public void suspendTable() {
        this.metadata.suspendTable();
    }

    private void applyToMetadata(TableMetadataChange change) {
        change.apply(this.metadataSvc, true);
        this.metadata.syncToMetaFile();
    }

    private void checkDropped() {
        if (this.metadata.isDropped()) {
            throw CairoException.nonCritical().put("table is dropped [dirName=").put(this.tableToken.getDirName()).put(']');
        }
    }

    private boolean closeLocked() {
        if (!this.closed) {
            this.closed = true;
            Misc.free(this.metadata);
            Misc.free(this.tableTransactionLog);
            Misc.free(this.walIdGenerator);
            Misc.free(this.path);
            return true;
        }
        return false;
    }

    private void createSequencerDir(FilesFacade ff, int mkDirMode) {
        if (ff.mkdirs(this.path.slash$(), mkDirMode) != 0) {
            CairoException e = CairoException.critical(ff.errno()).put("Cannot create sequencer directory: ").put(this.path);
            this.closeLocked();
            throw e;
        }
        this.path.trimTo(this.rootLen);
    }

    private long nextTxn(int walId, int segmentId, int segmentTxn) {
        return this.tableTransactionLog.addEntry(this.getStructureVersion(), walId, segmentId, segmentTxn, this.microClock.getTicks());
    }

    void create(int tableId, TableStructure model) {
        this.schemaLock.writeLock().lock();
        try {
            this.createSequencerDir(this.ff, this.mkDirMode);
            this.metadata.create(model, this.tableToken, this.path, this.rootLen, tableId);
        }
        finally {
            this.schemaLock.writeLock().unlock();
        }
    }

    void readLock() {
        this.schemaLock.readLock().lock();
    }

    void unlockRead() {
        this.schemaLock.readLock().unlock();
    }

    void unlockWrite() {
        this.schemaLock.writeLock().unlock();
    }

    void writeLock() {
        this.schemaLock.writeLock().lock();
    }
}

