/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.vm;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.MemoryPARWImpl;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;

public class MemorySRImpl
extends MemoryPARWImpl {
    private static final Log LOG = LogFactory.getLog(MemorySRImpl.class);
    private int fd = -1;
    private FilesFacade ff;
    private long pageAddress;
    private int pageIndex;
    private MemoryMA parent;
    private long size = 0L;

    @Override
    public void close() {
        super.close();
        this.closeFile();
        this.releasePage();
    }

    public int getFd() {
        return this.fd;
    }

    @Override
    public long getPageAddress(int page) {
        return page == this.pageIndex ? this.pageAddress : this.mapPage(page);
    }

    @Override
    public long getPageSize() {
        return this.getExtendSegmentSize();
    }

    public void of(MemoryMA parent, int memoryTag) {
        this.close();
        this.memoryTag = memoryTag;
        this.ff = parent.getFilesFacade();
        this.fd = parent.getFd();
        this.parent = parent;
        this.setExtendSegmentSize(parent.getExtendSegmentSize());
        this.updateSize();
        this.pageIndex = -1;
        LOG.debug().$("open [fd=").$(this.fd).$(", size=").$(this.size).$(']').$();
    }

    public void updateSize() {
        if (this.parent != null) {
            this.size = this.pageOffset(this.pageIndex(this.parent.getAppendOffset())) + this.getExtendSegmentSize();
        }
    }

    private void closeFile() {
        if (this.fd != -1) {
            LOG.debug().$("closed [fd=").$(this.fd).$(']').$();
            this.fd = -1;
            this.size = 0L;
            this.parent = null;
        }
    }

    private void invalidateCurrentPage() {
        this.pageAddress = 0L;
        this.pageIndex = -1;
        this.clearHotPage();
    }

    private long mapPage(int page) {
        this.releaseCurrentPage();
        long offset = this.pageOffset(page);
        long sz = this.size - offset;
        if (sz > 0L) {
            try {
                long address = TableUtils.mapRO(this.ff, this.fd, this.getExtendSegmentSize(), offset, this.memoryTag);
                this.pageIndex = page;
                this.pageAddress = address;
                return address;
            }
            catch (Throwable e) {
                this.invalidateCurrentPage();
                throw e;
            }
        }
        this.invalidateCurrentPage();
        throw CairoException.critical(this.ff.errno()).put("Trying to map read-only page outside of file boundary. fd=").put(this.fd).put(", offset=").put(offset).put(", size=").put(this.size).put(", page=").put(sz);
    }

    private void releaseCurrentPage() {
        if (this.pageAddress != 0L) {
            this.ff.munmap(this.pageAddress, this.getExtendSegmentSize(), this.memoryTag);
            this.pageAddress = 0L;
        }
    }

    private void releasePage() {
        this.releaseCurrentPage();
        this.invalidateCurrentPage();
    }

    @Override
    protected long mapWritePage(int page, long offset) {
        throw new UnsupportedOperationException("Cannot jump() read-only memory. Use extend() instead.");
    }
}

