/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.hash;

import java.util.AbstractSet;
import java.util.Iterator;
import jetbrains.exodus.core.dataStructures.hash.HashUtil;
import jetbrains.exodus.util.MathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinkedHashSet<E>
extends AbstractSet<E> {
    private Entry<E>[] table;
    private Entry<E> top;
    private Entry<E> back;
    private int capacity;
    private int size;
    private final float loadFactor;
    private int mask;
    private boolean holdsNull;

    public LinkedHashSet() {
        this(0);
    }

    public LinkedHashSet(int capacity) {
        this(capacity, 1.0f);
    }

    public LinkedHashSet(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.init(capacity);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object key) {
        if (key == null) {
            return this.holdsNull;
        }
        Entry<E>[] table = this.table;
        int hash = key.hashCode();
        int index = HashUtil.indexFor(hash, table.length, this.mask);
        Entry e = table[index];
        while (e != null) {
            Object entryKey = e.key;
            if (entryKey == key || entryKey.equals(key)) {
                return true;
            }
            e = e.hashNext;
        }
        return false;
    }

    @Override
    public boolean add(E key) {
        if (key == null) {
            boolean wasHoldingNull = this.holdsNull;
            this.holdsNull = true;
            if (!wasHoldingNull) {
                ++this.size;
            }
            return !wasHoldingNull;
        }
        Entry<E>[] table = this.table;
        int hash = key.hashCode();
        int index = HashUtil.indexFor(hash, table.length, this.mask);
        Entry e = table[index];
        while (e != null) {
            Object entryKey = e.key;
            if (entryKey == key || entryKey.equals(key)) {
                return false;
            }
            e = e.hashNext;
        }
        e = new Entry(key);
        e.hashNext = (Entry)table[index];
        table[index] = e;
        Entry<E> top = this.top;
        e.next = (Entry)top;
        if (top != null) {
            ((Entry)top).previous = e;
        } else {
            this.back = e;
        }
        this.top = e;
        ++this.size;
        if (this.size > this.capacity) {
            this.rehash(HashUtil.nextCapacity(this.capacity));
        }
        return true;
    }

    @Override
    public boolean remove(Object key) {
        if (key == null) {
            boolean wasHoldingNull = this.holdsNull;
            this.holdsNull = false;
            if (wasHoldingNull) {
                --this.size;
            }
            return wasHoldingNull;
        }
        Entry<E>[] table = this.table;
        int hash = key.hashCode();
        int index = HashUtil.indexFor(hash, table.length, this.mask);
        Entry e = table[index];
        if (e == null) {
            return false;
        }
        Object entryKey = e.key;
        if (entryKey == key || entryKey.equals(key)) {
            table[index] = e.hashNext;
        } else {
            Entry last;
            do {
                last = e;
                if ((e = e.hashNext) != null) continue;
                return false;
            } while ((entryKey = e.key) != key && !entryKey.equals(key));
            last.hashNext = e.hashNext;
        }
        this.unlink(e);
        --this.size;
        return true;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new LinkedHashIterator();
    }

    @Nullable
    public E getTop() {
        return (E)(this.top == null ? null : ((Entry)this.top).key);
    }

    @Nullable
    public E getBack() {
        return (E)(this.back == null ? null : ((Entry)this.back).key);
    }

    private void allocateTable(int length) {
        this.table = new Entry[length];
        this.mask = (1 << MathUtil.integerLogarithm(this.table.length)) - 1;
    }

    private void init(int capacity) {
        if (capacity < 4) {
            capacity = 4;
        }
        this.allocateTable(HashUtil.getCeilingPrime((int)((float)capacity / this.loadFactor)));
        this.back = null;
        this.top = null;
        this.capacity = capacity;
        this.size = 0;
        this.holdsNull = false;
    }

    private void unlink(Entry<E> e) {
        Entry prev = ((Entry)e).previous;
        Entry next = ((Entry)e).next;
        if (prev != null) {
            prev.next = next;
        } else {
            this.top = next;
        }
        if (next != null) {
            next.previous = prev;
        } else {
            this.back = prev;
        }
    }

    private void rehash(int capacity) {
        int length = HashUtil.getCeilingPrime((int)((float)capacity / this.loadFactor));
        this.capacity = capacity;
        if (length != this.table.length) {
            this.allocateTable(length);
            Entry<E>[] table = this.table;
            int mask = this.mask;
            Entry e = this.back;
            while (e != null) {
                int index = HashUtil.indexFor(e.key.hashCode(), length, mask);
                e.hashNext = (Entry)table[index];
                table[index] = e;
                e = e.previous;
            }
        }
    }

    private class LinkedHashIterator
    implements Iterator<E> {
        private Entry<E> e;
        private Entry<E> last;

        private LinkedHashIterator() {
            Entry back = LinkedHashSet.this.back;
            if (LinkedHashSet.this.holdsNull) {
                this.e = new Entry();
                this.e.previous = back;
            } else {
                this.e = back;
            }
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            LinkedHashSet.this.remove(this.last.key);
            this.last = null;
        }

        @Override
        public E next() {
            this.last = this.e;
            Entry result = this.last;
            this.e = result.previous;
            return result.key;
        }
    }

    private static class Entry<E> {
        private final E key;
        private Entry<E> next;
        private Entry<E> previous;
        private Entry<E> hashNext;

        private Entry() {
            this.key = null;
        }

        private Entry(E key) {
            this.key = key;
        }
    }
}

