/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.minifi.bootstrap.RunMiNiFi;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeListener;
import org.apache.nifi.minifi.bootstrap.configuration.differentiators.Differentiator;
import org.apache.nifi.minifi.bootstrap.configuration.differentiators.WholeConfigDifferentiator;
import org.apache.nifi.minifi.bootstrap.service.BootstrapFileProvider;
import org.apache.nifi.minifi.bootstrap.util.ByteBufferInputStream;
import org.apache.nifi.minifi.bootstrap.util.ConfigTransformer;
import org.apache.nifi.minifi.commons.api.MiNiFiCommandState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateConfigurationService {
    private static final Logger logger = LoggerFactory.getLogger(UpdateConfigurationService.class);
    private static final String FALLBACK_CONFIG_FILE_DIR = "./conf/";
    private final Differentiator<ByteBuffer> differentiator = WholeConfigDifferentiator.getByteBufferDifferentiator();
    private final RunMiNiFi runMiNiFi;
    private final ConfigurationChangeListener miNiFiConfigurationChangeListener;
    private final BootstrapFileProvider bootstrapFileProvider;

    public UpdateConfigurationService(RunMiNiFi runMiNiFi, ConfigurationChangeListener miNiFiConfigurationChangeListener, BootstrapFileProvider bootstrapFileProvider) {
        this.differentiator.initialize(runMiNiFi);
        this.runMiNiFi = runMiNiFi;
        this.miNiFiConfigurationChangeListener = miNiFiConfigurationChangeListener;
        this.bootstrapFileProvider = bootstrapFileProvider;
    }

    public Optional<MiNiFiCommandState> handleUpdate() {
        logger.info("Handling configuration update");
        MiNiFiCommandState commandState = null;
        try (FileInputStream configFile = new FileInputStream(this.getConfigFilePath().toFile());){
            ByteBuffer readOnlyNewConfig = ConfigTransformer.overrideNonFlowSectionsFromOriginalSchema(IOUtils.toByteArray((InputStream)configFile), this.runMiNiFi.getConfigFileReference().get().duplicate(), this.bootstrapFileProvider.getBootstrapProperties());
            if (this.differentiator.isNew(readOnlyNewConfig)) {
                this.miNiFiConfigurationChangeListener.handleChange(new ByteBufferInputStream(readOnlyNewConfig.duplicate()));
            } else {
                logger.info("The given configuration does not contain any update. No operation required");
                commandState = MiNiFiCommandState.NO_OPERATION;
            }
        }
        catch (Exception e) {
            commandState = MiNiFiCommandState.NOT_APPLIED_WITHOUT_RESTART;
            logger.error("Could not handle configuration update", (Throwable)e);
        }
        return Optional.ofNullable(commandState);
    }

    private Path getConfigFilePath() {
        return Optional.ofNullable(this.safeGetPropertiesFilePath()).map(File::new).map(File::getParent).map(parentDir -> new File(parentDir + "config-updated.yml")).orElse(new File("./conf/config-updated.yml")).toPath();
    }

    private String safeGetPropertiesFilePath() {
        String propertyFile = null;
        try {
            propertyFile = this.bootstrapFileProvider.getBootstrapProperties().getProperty("nifi.properties.file.path", null);
        }
        catch (IOException e) {
            logger.error("Failed to get properties file path");
        }
        return propertyFile;
    }
}

