/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.nifi.bootstrap.util.RuntimeVersionProvider;
import org.apache.nifi.minifi.bootstrap.service.BootstrapFileProvider;

public class MiNiFiExecCommandProvider {
    public static final String LOG_DIR = "org.apache.nifi.minifi.bootstrap.config.log.dir";
    public static final String DEFAULT_LOG_DIR = "./logs";
    public static final String APP_LOG_FILE_NAME = "org.apache.nifi.minifi.bootstrap.config.log.app.file.name";
    public static final String APP_LOG_FILE_EXTENSION = "org.apache.nifi.minifi.bootstrap.config.log.app.file.extension";
    public static final String BOOTSTRAP_LOG_FILE_NAME = "org.apache.nifi.minifi.bootstrap.config.log.bootstrap.file.name";
    public static final String BOOTSTRAP_LOG_FILE_EXTENSION = "org.apache.nifi.minifi.bootstrap.config.log.bootstrap.file.extension";
    public static final String DEFAULT_APP_LOG_FILE_NAME = "minifi-app";
    public static final String DEFAULT_BOOTSTRAP_LOG_FILE_NAME = "minifi-bootstrap";
    public static final String DEFAULT_LOG_FILE_EXTENSION = "log";
    private static final String DEFAULT_JAVA_CMD = "java";
    private static final String DEFAULT_LIB_DIR = "./lib";
    private static final String DEFAULT_CONF_DIR = "./conf";
    private static final String DEFAULT_CONFIG_FILE = "./conf/bootstrap.conf";
    private static final String WINDOWS_FILE_EXTENSION = ".exe";
    private final BootstrapFileProvider bootstrapFileProvider;

    public MiNiFiExecCommandProvider(BootstrapFileProvider bootstrapFileProvider) {
        this.bootstrapFileProvider = bootstrapFileProvider;
    }

    public List<String> getMiNiFiExecCommand(int listenPort, File workingDir) throws IOException {
        Properties props = this.bootstrapFileProvider.getBootstrapProperties();
        File confDir = this.getFile(props.getProperty("conf.dir", DEFAULT_CONF_DIR).trim(), workingDir);
        File libDir = this.getFile(props.getProperty("lib.dir", DEFAULT_LIB_DIR).trim(), workingDir);
        String minifiLogDir = System.getProperty(LOG_DIR, DEFAULT_LOG_DIR).trim();
        String minifiAppLogFileName = System.getProperty(APP_LOG_FILE_NAME, DEFAULT_APP_LOG_FILE_NAME).trim();
        String minifiAppLogFileExtension = System.getProperty(APP_LOG_FILE_EXTENSION, DEFAULT_LOG_FILE_EXTENSION).trim();
        String minifiBootstrapLogFileName = System.getProperty(BOOTSTRAP_LOG_FILE_NAME, DEFAULT_BOOTSTRAP_LOG_FILE_NAME).trim();
        String minifiBootstrapLogFileExtension = System.getProperty(BOOTSTRAP_LOG_FILE_EXTENSION, DEFAULT_LOG_FILE_EXTENSION).trim();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getJavaCommand(props));
        cmd.add("-classpath");
        cmd.add(this.buildClassPath(props, confDir, libDir));
        cmd.addAll(this.getJavaAdditionalArgs(props));
        cmd.add("-Dnifi.properties.file.path=" + this.getMiNiFiPropsFileName(props, confDir));
        cmd.add("-Dnifi.bootstrap.listen.port=" + listenPort);
        cmd.add("-Dapp=MiNiFi");
        cmd.add("-Dorg.apache.nifi.minifi.bootstrap.config.log.dir=" + minifiLogDir);
        cmd.add("-Dorg.apache.nifi.minifi.bootstrap.config.log.app.file.name=" + minifiAppLogFileName);
        cmd.add("-Dorg.apache.nifi.minifi.bootstrap.config.log.app.file.extension=" + minifiAppLogFileExtension);
        cmd.add("-Dorg.apache.nifi.minifi.bootstrap.config.log.bootstrap.file.name=" + minifiBootstrapLogFileName);
        cmd.add("-Dorg.apache.nifi.minifi.bootstrap.config.log.bootstrap.file.extension=" + minifiBootstrapLogFileExtension);
        cmd.add("org.apache.nifi.minifi.MiNiFi");
        return cmd;
    }

    private String getJavaCommand(Properties props) {
        String javaCmd = props.getProperty(DEFAULT_JAVA_CMD);
        if (javaCmd == null) {
            javaCmd = DEFAULT_JAVA_CMD;
        }
        if (javaCmd.equals(DEFAULT_JAVA_CMD)) {
            Optional.ofNullable(System.getenv("JAVA_HOME")).map(javaHome -> this.getJavaCommandBasedOnExtension((String)javaHome, WINDOWS_FILE_EXTENSION).orElseGet(() -> this.getJavaCommandBasedOnExtension((String)javaHome, "").orElse(DEFAULT_JAVA_CMD)));
        }
        return javaCmd;
    }

    private Optional<String> getJavaCommandBasedOnExtension(String javaHome, String extension) {
        String javaCmd = null;
        File javaFile = new File(javaHome + File.separatorChar + "bin" + File.separatorChar + DEFAULT_JAVA_CMD + extension);
        if (javaFile.exists() && javaFile.canExecute()) {
            javaCmd = javaFile.getAbsolutePath();
        }
        return Optional.ofNullable(javaCmd);
    }

    private String buildClassPath(Properties props, File confDir, File libDir) {
        File[] libFiles = libDir.listFiles((dir, filename) -> filename.toLowerCase().endsWith(".jar"));
        if (libFiles == null || libFiles.length == 0) {
            throw new RuntimeException("Could not find lib directory at " + libDir.getAbsolutePath());
        }
        File[] confFiles = confDir.listFiles();
        if (confFiles == null || confFiles.length == 0) {
            throw new RuntimeException("Could not find conf directory at " + confDir.getAbsolutePath());
        }
        ArrayList<String> cpFiles = new ArrayList<String>(confFiles.length + libFiles.length);
        cpFiles.add(confDir.getAbsolutePath());
        for (File file : libFiles) {
            cpFiles.add(file.getAbsolutePath());
        }
        cpFiles.addAll(this.getJava11Files(libDir));
        StringBuilder classPathBuilder = new StringBuilder();
        for (int i = 0; i < cpFiles.size(); ++i) {
            String filename2 = (String)cpFiles.get(i);
            classPathBuilder.append(filename2);
            if (i >= cpFiles.size() - 1) continue;
            classPathBuilder.append(File.pathSeparatorChar);
        }
        return classPathBuilder.toString();
    }

    private List<String> getJava11Files(File libDir) {
        File libJava11Dir;
        ArrayList<String> java11Files = new ArrayList<String>();
        int javaMajorVersion = RuntimeVersionProvider.getMajorVersion();
        if (javaMajorVersion >= 11 && (libJava11Dir = this.getFile("java11", libDir)).exists()) {
            for (File file : libJava11Dir.listFiles((dir, filename) -> filename.toLowerCase().endsWith(".jar"))) {
                java11Files.add(file.getAbsolutePath());
            }
        }
        return java11Files;
    }

    private List<String> getJavaAdditionalArgs(Properties props) {
        ArrayList<String> javaAdditionalArgs = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith("java.arg")) continue;
            javaAdditionalArgs.add(value);
        }
        return javaAdditionalArgs;
    }

    private String getMiNiFiPropsFileName(Properties props, File confDir) {
        String minifiPropsFilename = props.getProperty("props.file");
        if (minifiPropsFilename == null) {
            minifiPropsFilename = confDir.exists() ? new File(confDir, "nifi.properties").getAbsolutePath() : DEFAULT_CONFIG_FILE;
        }
        return minifiPropsFilename.trim();
    }

    private File getFile(String filename, File workingDir) {
        File file = new File(filename);
        if (!file.isAbsolute()) {
            file = new File(workingDir, filename);
        }
        return file;
    }
}

