/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.protocol.api;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

@ApiModel
public class AgentRepositoryStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long size;
    private Long sizeMax;
    private Long dataSize;
    private Long dataSizeMax;

    @ApiModelProperty(value="The number of items in the repository", allowableValues="range[0, 9223372036854775807]")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    @ApiModelProperty(value="The maximum number of items the repository is capable of storing", allowableValues="range[0, 9223372036854775807]")
    public Long getSizeMax() {
        return this.sizeMax;
    }

    public void setSizeMax(Long sizeMax) {
        this.sizeMax = sizeMax;
    }

    @ApiModelProperty(value="The data size (in Bytes) of all items in the repository", allowableValues="range[0, 9223372036854775807]")
    public Long getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(Long dataSize) {
        this.dataSize = dataSize;
    }

    @ApiModelProperty(value="The maximum data size (in Bytes) that the repository is capable of storing", allowableValues="range[0, 9223372036854775807]")
    public Long getDataSizeMax() {
        return this.dataSizeMax;
    }

    public void setDataSizeMax(Long dataSizeMax) {
        this.dataSizeMax = dataSizeMax;
    }

    @ApiModelProperty(hidden=true)
    public Double getSizeUtilization() {
        return this.size != null && this.sizeMax != null && this.sizeMax > 0L ? Double.valueOf((double)this.size.longValue() / (double)this.sizeMax.longValue()) : null;
    }

    @ApiModelProperty(hidden=true)
    public Double getDataSizeUtilization() {
        return this.dataSize != null && this.dataSizeMax != null && this.dataSizeMax > 0L ? Double.valueOf((double)this.dataSize.longValue() / (double)this.dataSizeMax.longValue()) : null;
    }
}

