/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import jpt.sun.source.tree.IfTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.hints.Bundle;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.openide.util.NbBundle;

public class EmptyStatements {
    private static final String SUPPRESS_WARNINGS_KEY = "empty-statement";

    public static ErrorDescription forBLOCK(HintContext ctx) {
        Tree parent = ctx.getPath().getParentPath().getLeaf();
        if (!EnumSet.of(Tree.Kind.BLOCK).contains((Object)parent.getKind())) {
            return null;
        }
        ArrayList<Fix> fixes = new ArrayList<Fix>();
        fixes.add(FixFactory.createSuppressWarningsFix(ctx.getInfo(), ctx.getPath(), SUPPRESS_WARNINGS_KEY));
        fixes.add(JavaFixUtilities.removeFromParent(ctx, Bundle.ERR_EmptyBLOCK(), ctx.getPath()));
        return EmptyStatements.createErrorDescription(ctx, ctx.getPath().getLeaf(), fixes, Tree.Kind.BLOCK);
    }

    public static ErrorDescription forWHILE_LOOP(HintContext ctx) {
        TreePath parentPath = ctx.getPath().getParentPath();
        Tree parentLeaf = parentPath.getLeaf();
        if (!EnumSet.of(Tree.Kind.WHILE_LOOP).contains((Object)parentLeaf.getKind())) {
            return null;
        }
        ArrayList<Fix> fixes = new ArrayList<Fix>();
        fixes.add(FixFactory.createSuppressWarningsFix(ctx.getInfo(), parentPath, SUPPRESS_WARNINGS_KEY));
        return EmptyStatements.createErrorDescription(ctx, parentLeaf, fixes, Tree.Kind.WHILE_LOOP);
    }

    public static ErrorDescription forIF(HintContext ctx) {
        TreePath treePath = ctx.getPath();
        Tree parent = treePath.getParentPath().getLeaf();
        if (!EnumSet.of(Tree.Kind.IF).contains((Object)parent.getKind())) {
            return null;
        }
        TreePath treePathForWarning = treePath;
        IfTree it = (IfTree)parent;
        if (it.getThenStatement() != null && it.getThenStatement().getKind() == Tree.Kind.EMPTY_STATEMENT) {
            treePathForWarning = treePath.getParentPath();
        }
        if (it.getElseStatement() != null && it.getElseStatement().getKind() == Tree.Kind.EMPTY_STATEMENT) {
            treePathForWarning = treePath;
        }
        ArrayList<Fix> fixes = new ArrayList<Fix>();
        fixes.add(FixFactory.createSuppressWarningsFix(ctx.getInfo(), treePathForWarning, SUPPRESS_WARNINGS_KEY));
        return EmptyStatements.createErrorDescription(ctx, parent, fixes, parent.getKind());
    }

    public static ErrorDescription forFOR_LOOP(HintContext ctx) {
        Tree parent = ctx.getPath().getParentPath().getLeaf();
        if (!EnumSet.of(Tree.Kind.FOR_LOOP, Tree.Kind.ENHANCED_FOR_LOOP).contains((Object)parent.getKind())) {
            return null;
        }
        ArrayList<Fix> fixes = new ArrayList<Fix>();
        fixes.add(FixFactory.createSuppressWarningsFix(ctx.getInfo(), ctx.getPath().getParentPath(), SUPPRESS_WARNINGS_KEY));
        return EmptyStatements.createErrorDescription(ctx, parent, fixes, parent.getKind());
    }

    public static ErrorDescription forDO_WHILE_LOOP(HintContext ctx) {
        Tree parent = ctx.getPath().getParentPath().getLeaf();
        if (!Tree.Kind.DO_WHILE_LOOP.equals((Object)parent.getKind())) {
            return null;
        }
        ArrayList<Fix> fixes = new ArrayList<Fix>();
        fixes.add(FixFactory.createSuppressWarningsFix(ctx.getInfo(), ctx.getPath().getParentPath(), SUPPRESS_WARNINGS_KEY));
        return EmptyStatements.createErrorDescription(ctx, parent, fixes, parent.getKind());
    }

    static String getDisplayName(@NonNull Tree.Kind treeKind) {
        return NbBundle.getMessage(EmptyStatements.class, "LBL_Empty_" + treeKind.toString());
    }

    private static ErrorDescription createErrorDescription(HintContext ctx, Tree leaf, List<Fix> fixes, Tree.Kind treeKind) {
        int start = (int)ctx.getInfo().getTrees().getSourcePositions().getStartPosition(ctx.getInfo().getCompilationUnit(), leaf);
        int end = (int)ctx.getInfo().getTrees().getSourcePositions().getEndPosition(ctx.getInfo().getCompilationUnit(), leaf);
        return ErrorDescriptionFactory.forSpan(ctx, start, end, EmptyStatements.getDisplayName(treeKind), fixes.toArray(new Fix[fixes.size()]));
    }
}

