/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit;

import java.io.OutputStream;
import java.io.Writer;
import java.util.concurrent.ConcurrentMap;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.util.Service;
import org.apache.myfaces.trinidadinternal.renderkit.RenderKitBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RenderKitDecorator
extends RenderKitBase
implements Service.Provider {
    private static final String _RENDER_KIT_FACTORY_KEY = "org.apache.myfaces.trinidadinternal.renderkit.RenderKitDecorator.RENDER_KIT_FACTORY_KEY";

    public <T> T getService(Class<T> serviceClass) {
        return (T)Service.getService((Object)this.getRenderKit(), serviceClass);
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeList, String encoding) {
        RenderKit renderKit = this.getRenderKit();
        ResponseWriter out = renderKit.createResponseWriter(writer, contentTypeList, encoding);
        return this.createDecoratedResponseWriter(out);
    }

    public ResponseStream createResponseStream(OutputStream out) {
        return this.getRenderKit().createResponseStream(out);
    }

    public ResponseStateManager getResponseStateManager() {
        return this.getRenderKit().getResponseStateManager();
    }

    protected ResponseWriter createDecoratedResponseWriter(ResponseWriter delegate) {
        return delegate;
    }

    @Override
    public Renderer findRenderer(String componentFamily, String rendererType) {
        RenderKit renderKit;
        Renderer renderer = super.findRenderer(componentFamily, rendererType);
        if (renderer == null && (renderer = (renderKit = this.getRenderKit()) instanceof RenderKitBase ? ((RenderKitBase)renderKit).findRenderer(componentFamily, rendererType) : renderKit.getRenderer(componentFamily, rendererType)) != null) {
            this.addRenderer(componentFamily, rendererType, renderer);
        }
        return renderer;
    }

    protected RenderKit getRenderKit() {
        RenderKitFactory oldFactory;
        FacesContext context = FacesContext.getCurrentInstance();
        ConcurrentMap appMap = RequestContext.getCurrentInstance().getApplicationScopedConcurrentMap();
        RenderKitFactory factory = (RenderKitFactory)appMap.get(_RENDER_KIT_FACTORY_KEY);
        if (factory == null && (oldFactory = appMap.putIfAbsent(_RENDER_KIT_FACTORY_KEY, factory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory"))) != null) {
            factory = oldFactory;
        }
        RenderKit renderKit = factory.getRenderKit(context, this.getDecoratedRenderKitId());
        assert (renderKit != null);
        return renderKit;
    }

    protected abstract String getDecoratedRenderKitId();
}

