/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.taglib.listener;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.FacesBeanImpl;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.apache.myfaces.trinidad.util.MessageFactory;
import org.apache.myfaces.trinidadinternal.util.MimeUtility;

public class FileDownloadActionListener
extends FacesBeanImpl
implements ActionListener,
StateHolder {
    public static final FacesBean.Type TYPE = new FacesBean.Type();
    public static final PropertyKey FILENAME_KEY = TYPE.registerKey("filename");
    public static final PropertyKey CONTENT_TYPE_KEY = TYPE.registerKey("contentType");
    public static final PropertyKey METHOD_KEY = TYPE.registerKey("method", MethodBinding.class, 9);
    public static final String DOWNLOAD_MESSAGE_ID = "org.apache.myfaces.trinidad.event.FileDownloadActionListener.DOWNLOAD_ERROR";
    private static final TrinidadLogger _LOG;

    public void processAction(ActionEvent event) {
        String filename = this.getFilename();
        String contentType = this.getContentType();
        FacesContext context = FacesContext.getCurrentInstance();
        Object response = context.getExternalContext().getResponse();
        if (!(response instanceof HttpServletResponse)) {
            _LOG.warning("FILE_DOWNLOAD_LISTENER_REQUIRES_SERVLET");
        } else {
            HttpServletResponse hsr = (HttpServletResponse)response;
            try {
                if (contentType != null) {
                    hsr.setContentType(contentType);
                }
                if (filename != null) {
                    boolean isGecko = true;
                    Map headers = context.getExternalContext().getRequestHeaderMap();
                    String agentName = ((String)headers.get("User-Agent")).toLowerCase();
                    if (agentName.contains("msie") || agentName.contains("applewebkit") || agentName.contains("safari")) {
                        isGecko = false;
                    }
                    String encodeHTTPHeaderFilename = MimeUtility.encodeHTTPHeader(filename, !isGecko);
                    hsr.setHeader("Content-Disposition", "attachment; filename=\"" + encodeHTTPHeaderFilename + "\"");
                }
                MethodBinding method = this.getMethod();
                BufferedOutputStream out = new BufferedOutputStream((OutputStream)hsr.getOutputStream());
                method.invoke(context, new Object[]{context, out});
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                hsr.reset();
                _LOG.warning((Throwable)e);
                FacesMessage message = MessageFactory.getMessage((FacesContext)context, (String)DOWNLOAD_MESSAGE_ID);
                context.addMessage(null, message);
                context.renderResponse();
                return;
            }
        }
        context.responseComplete();
    }

    public MethodBinding getMethod() {
        return (MethodBinding)this.getProperty(METHOD_KEY);
    }

    public void setMethod(MethodBinding method) {
        this.setProperty(METHOD_KEY, method);
    }

    public String getFilename() {
        return ComponentUtils.resolveString((Object)this.getProperty(FILENAME_KEY));
    }

    public void setFilename(String filename) {
        this.setProperty(FILENAME_KEY, filename);
    }

    public String getContentType() {
        return ComponentUtils.resolveString((Object)this.getProperty(CONTENT_TYPE_KEY));
    }

    public void setContentType(String contentType) {
        this.setProperty(CONTENT_TYPE_KEY, contentType);
    }

    public FacesBean.Type getType() {
        return TYPE;
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean newTransientValue) {
        throw new UnsupportedOperationException();
    }

    static {
        TYPE.lock();
        _LOG = TrinidadLogger.createTrinidadLogger(FileDownloadActionListener.class);
    }
}

