/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.apache.myfaces.trinidad.util.MessageFactory;
import org.apache.myfaces.trinidad.validator.ValidatorUtils;

public class DoubleRangeValidator
extends javax.faces.validator.DoubleRangeValidator {
    public static final String VALIDATOR_ID = "org.apache.myfaces.trinidad.DoubleRange";
    public static final String MAXIMUM_MESSAGE_ID = "org.apache.myfaces.trinidad.validator.DoubleRangeValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "org.apache.myfaces.trinidad.validator.DoubleRangeValidator.MINIMUM";
    public static final String NOT_IN_RANGE_MESSAGE_ID = "org.apache.myfaces.trinidad.validator.DoubleRangeValidator.NOT_IN_RANGE";
    public static final String CONVERT_MESSAGE_ID = "org.apache.myfaces.trinidad.convert.DoubleConverter.CONVERT";
    private static final FacesBean.Type _TYPE = new FacesBean.Type();
    private static final PropertyKey _MINIMUM_KEY = _TYPE.registerKey("minimum", Double.class, Double.MIN_VALUE);
    private static final PropertyKey _MAXIMUM_KEY = _TYPE.registerKey("maximum", Double.class, Double.MAX_VALUE);
    private static final PropertyKey _MAXIMUM_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailMaximum", String.class);
    private static final PropertyKey _MINIMUM_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailMinimum", String.class);
    private static final PropertyKey _NOT_IN_RANGE_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailNotInRange", String.class);
    private static final PropertyKey _HINT_MAXIMUM_KEY = _TYPE.registerKey("hintMaximum", String.class);
    private static final PropertyKey _HINT_MINIMUM_KEY = _TYPE.registerKey("hintMinimum", String.class);
    private static final PropertyKey _HINT_NOT_IN_RANGE = _TYPE.registerKey("hintNotInRange", String.class);
    private FacesBean _facesBean = ValidatorUtils.getFacesBean(_TYPE);
    private boolean _transientValue = false;

    public DoubleRangeValidator() {
    }

    public DoubleRangeValidator(double maximum) {
        super(maximum);
    }

    public DoubleRangeValidator(double maximum, double minimum) {
        super(maximum, minimum);
    }

    public double getMaximum() {
        Object maxDouble = this._facesBean.getProperty(_MAXIMUM_KEY);
        if (maxDouble == null) {
            maxDouble = _MAXIMUM_KEY.getDefault();
        }
        return ComponentUtils.resolveDouble(maxDouble);
    }

    public void setMaximum(double maximum) {
        super.setMaximum(maximum);
        this._facesBean.setProperty(_MAXIMUM_KEY, maximum);
    }

    public double getMinimum() {
        Object minDouble = this._facesBean.getProperty(_MINIMUM_KEY);
        if (minDouble == null) {
            minDouble = _MINIMUM_KEY.getDefault();
        }
        return ComponentUtils.resolveDouble(minDouble);
    }

    public void setMinimum(double minimum) {
        super.setMinimum(minimum);
        this._facesBean.setProperty(_MINIMUM_KEY, minimum);
    }

    public void setMessageDetailMaximum(String maximumMessageDetail) {
        this._facesBean.setProperty(_MAXIMUM_MESSAGE_DETAIL_KEY, maximumMessageDetail);
    }

    public String getMessageDetailMaximum() {
        Object maxMsgDet = this._facesBean.getProperty(_MAXIMUM_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(maxMsgDet);
    }

    public void setMessageDetailMinimum(String minimumMessageDetail) {
        this._facesBean.setProperty(_MINIMUM_MESSAGE_DETAIL_KEY, minimumMessageDetail);
    }

    public String getMessageDetailMinimum() {
        Object minMsgDet = this._facesBean.getProperty(_MINIMUM_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(minMsgDet);
    }

    public void setMessageDetailNotInRange(String notInRangeMessageDetail) {
        this._facesBean.setProperty(_NOT_IN_RANGE_MESSAGE_DETAIL_KEY, notInRangeMessageDetail);
    }

    public String getMessageDetailNotInRange() {
        Object notInRngMsg = this._facesBean.getProperty(_NOT_IN_RANGE_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(notInRngMsg);
    }

    public void setHintMaximum(String hintMaximum) {
        this._facesBean.setProperty(_HINT_MAXIMUM_KEY, hintMaximum);
    }

    public String getHintMaximum() {
        Object obj = this._facesBean.getProperty(_HINT_MAXIMUM_KEY);
        return ComponentUtils.resolveString(obj);
    }

    public void setHintMinimum(String hintMinimum) {
        this._facesBean.setProperty(_HINT_MINIMUM_KEY, hintMinimum);
    }

    public String getHintMinimum() {
        Object obj = this._facesBean.getProperty(_HINT_MINIMUM_KEY);
        return ComponentUtils.resolveString(obj);
    }

    public void setHintNotInRange(String hintNotInRange) {
        this._facesBean.setProperty(_HINT_NOT_IN_RANGE, hintNotInRange);
    }

    public String getHintNotInRange() {
        Object obj = this._facesBean.getProperty(_HINT_NOT_IN_RANGE);
        return ComponentUtils.resolveString(obj);
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return;
        }
        try {
            double doubleValue = this._convertValueToDouble(value);
            double min = this.getMinimum();
            double max = this.getMaximum();
            if (this.isMaximumSet() && this.isMinimumSet() && (doubleValue < min || doubleValue > max)) {
                throw new ValidatorException(this._getNotInRangeMessage(context, component, value, min, max));
            }
            if (this.isMaximumSet() && doubleValue > max) {
                throw new ValidatorException(this._getMaximumMessage(context, component, value, max));
            }
            if (this.isMinimumSet() && doubleValue < min) {
                throw new ValidatorException(this._getMinimumMessage(context, component, value, min));
            }
        }
        catch (NumberFormatException nfe) {
            FacesMessage msg = this._getNotCorrectType(context);
            throw new ValidatorException(msg);
        }
    }

    public Object saveState(FacesContext context) {
        return this._facesBean.saveState(context);
    }

    public void restoreState(FacesContext context, Object state) {
        this._facesBean.restoreState(context, state);
    }

    public void setValueBinding(String name, ValueBinding binding) {
        ValidatorUtils.setValueBinding(this._facesBean, name, binding);
    }

    public ValueBinding getValueBinding(String name) {
        return ValidatorUtils.getValueBinding(this._facesBean, name);
    }

    public boolean isTransient() {
        return this._transientValue;
    }

    protected boolean isMaximumSet() {
        return this._facesBean.getProperty(_MAXIMUM_KEY) != null;
    }

    protected boolean isMinimumSet() {
        return this._facesBean.getProperty(_MINIMUM_KEY) != null;
    }

    private FacesMessage _getNotCorrectType(FacesContext context) {
        return MessageFactory.getMessage(context, CONVERT_MESSAGE_ID);
    }

    private double _convertValueToDouble(Object value) throws NumberFormatException {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return Double.parseDouble(value.toString());
    }

    public void setTransient(boolean transientValue) {
        this._transientValue = transientValue;
    }

    private FacesMessage _getNotInRangeMessage(FacesContext context, UIComponent component, Object value, Object min, Object max) {
        Object msg = this._getRawNotInRangeMessageDetail();
        Object label = ValidatorUtils.getComponentLabel(component);
        Object[] params = new Object[]{label, value, min, max};
        return MessageFactory.getMessage(context, NOT_IN_RANGE_MESSAGE_ID, msg, params, component);
    }

    private Object _getRawNotInRangeMessageDetail() {
        return this._facesBean.getRawProperty(_NOT_IN_RANGE_MESSAGE_DETAIL_KEY);
    }

    private FacesMessage _getMaximumMessage(FacesContext context, UIComponent component, Object value, Object max) {
        Object msg = this._getRawMaximumMessageDetail();
        Object label = ValidatorUtils.getComponentLabel(component);
        Object[] params = new Object[]{label, value, max};
        return MessageFactory.getMessage(context, MAXIMUM_MESSAGE_ID, msg, params, component);
    }

    private Object _getRawMaximumMessageDetail() {
        return this._facesBean.getRawProperty(_MAXIMUM_MESSAGE_DETAIL_KEY);
    }

    private FacesMessage _getMinimumMessage(FacesContext context, UIComponent component, Object value, Object min) {
        Object msg = this._getRawMinimumMessageDetail();
        Object label = ValidatorUtils.getComponentLabel(component);
        Object[] params = new Object[]{label, value, min};
        return MessageFactory.getMessage(context, MINIMUM_MESSAGE_ID, msg, params, component);
    }

    private Object _getRawMinimumMessageDetail() {
        return this._facesBean.getRawProperty(_MINIMUM_MESSAGE_DETAIL_KEY);
    }
}

