/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.config;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.myfaces.tobago.internal.config.TobagoConfigFragment;
import org.apache.myfaces.tobago.internal.config.TobagoConfigParser;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class TobagoConfigLoader {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String WEB_INF_TOBAGO_CONFIG_XML = "/WEB-INF/tobago-config.xml";
    private static final String[] META_INF_TOBAGO_CONFIG_XML = new String[]{"META-INF/tobago-config.xml"};

    private TobagoConfigLoader() {
    }

    public static void load(List<TobagoConfigFragment> fragments, ServletContext servletContext, String ... alternative) throws URISyntaxException, SAXException, ParserConfigurationException, IOException, ServletException {
        TobagoConfigLoader loader = new TobagoConfigLoader();
        loader.loadFromWebInf(fragments, servletContext);
        loader.loadFromClasspath(fragments, alternative);
    }

    private void loadFromWebInf(List<TobagoConfigFragment> configFragmentList, ServletContext servletContext) throws IOException, SAXException, ParserConfigurationException, URISyntaxException {
        if (servletContext != null) {
            URL url = servletContext.getResource(WEB_INF_TOBAGO_CONFIG_XML);
            if (url != null) {
                configFragmentList.add(new TobagoConfigParser().parse(url));
            }
        } else {
            LOG.warn("No ServletContext to look for files in {}", (Object)WEB_INF_TOBAGO_CONFIG_XML);
        }
    }

    private void loadFromClasspath(List<TobagoConfigFragment> configFragmentList, String ... alternative) throws ServletException {
        String[] configFiles = ArrayUtils.isEmpty(alternative) ? META_INF_TOBAGO_CONFIG_XML : alternative;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (String configFile : configFiles) {
                Enumeration<URL> urls = classLoader.getResources(configFile);
                while (urls.hasMoreElements()) {
                    URL themeUrl = urls.nextElement();
                    try {
                        TobagoConfigFragment fragment = new TobagoConfigParser().parse(themeUrl);
                        fragment.setUrl(themeUrl);
                        configFragmentList.add(fragment);
                        String protocol = themeUrl.getProtocol();
                        if ("file".equals(protocol) || "jar".equals(protocol) || "zip".equals(protocol) || "wsjar".equals(protocol)) continue;
                        LOG.warn("Unknown protocol '" + themeUrl + "'");
                    }
                    catch (Exception e) {
                        throw new Exception(e.getClass().getName() + " on themeUrl: " + themeUrl, e);
                    }
                }
            }
        }
        catch (Exception e) {
            String msg = "while loading ";
            LOG.error("while loading ", (Throwable)e);
            throw new ServletException("while loading ", (Throwable)e);
        }
    }
}

