/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIBadge;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class BadgeRenderer
extends RendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        AbstractUIBadge badge = (AbstractUIBadge)component;
        Markup markup = badge.getMarkup() != null ? badge.getMarkup() : Markup.NULL;
        String tip = badge.getTip();
        String value = RenderUtils.currentValue((UIComponent)badge);
        writer.startElement(HtmlElements.SPAN);
        writer.writeIdAttribute(badge.getClientId(facesContext));
        writer.writeClassAttribute((CssItem)TobagoClass.BADGE, TobagoClass.BADGE.createMarkup(markup), new CssItem[]{BootstrapClass.BADGE, this.getBadgeColor(markup), markup.contains(Markup.PILL) ? BootstrapClass.BADGE_PILL : null, this.getAdditionalCssItem(), badge.getCustomClass()});
        if (tip != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, tip, true);
        }
        if (value != null) {
            writer.writeText(value);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.SPAN);
    }

    protected CssItem getAdditionalCssItem() {
        return null;
    }

    private BootstrapClass getBadgeColor(Markup markup) {
        if (markup.contains(Markup.NONE)) {
            return null;
        }
        if (markup.contains(Markup.PRIMARY)) {
            return BootstrapClass.BADGE_PRIMARY;
        }
        if (markup.contains(Markup.SECONDARY)) {
            return BootstrapClass.BADGE_SECONDARY;
        }
        if (markup.contains(Markup.SUCCESS)) {
            return BootstrapClass.BADGE_SUCCESS;
        }
        if (markup.contains(Markup.DANGER)) {
            return BootstrapClass.BADGE_DANGER;
        }
        if (markup.contains(Markup.WARNING)) {
            return BootstrapClass.BADGE_WARNING;
        }
        if (markup.contains(Markup.INFO)) {
            return BootstrapClass.BADGE_INFO;
        }
        if (markup.contains(Markup.LIGHT)) {
            return BootstrapClass.BADGE_LIGHT;
        }
        if (markup.contains(Markup.DARK)) {
            return BootstrapClass.BADGE_DARK;
        }
        return BootstrapClass.BADGE_SECONDARY;
    }
}

