/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.component.InputSuggest2;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.UISelectManyBox;
import org.apache.myfaces.tobago.component.UISelectOneChoice;
import org.apache.myfaces.tobago.model.AutoSuggestItem;
import org.apache.myfaces.tobago.model.AutoSuggestItems;
import org.apache.myfaces.tobago.model.SuggestFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUISuggest
extends UIComponentBase
implements SupportsMarkup,
InputSuggest2 {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUISuggest.class);
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.Suggest";
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.tobago.Suggest";
    private static final String ITEM_MAP_KEY = "org.apache.myfaces.tobago.internal.component.AbstractUISuggest.ITEM_MAP_KEY";

    public String getFamily() {
        return "org.apache.myfaces.tobago.Suggest";
    }

    public AutoSuggestItems getSuggestItems(FacesContext facesContext) {
        UIInput in;
        MethodExpression suggestMethodExpression = this.getSuggestMethodExpression();
        if (this.isSelect2()) {
            String search = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get(this.getClientId());
            LOG.trace(" search = \"{}\"", (Object)search);
            in = new UIInput();
            in.setSubmittedValue((Object)search);
        } else {
            in = (UIInput)this.getParent();
        }
        AutoSuggestItems suggestItems = this.createAutoSuggestItems(suggestMethodExpression.invoke(facesContext.getELContext(), new Object[]{in}));
        if (!suggestItems.getItems().isEmpty()) {
            HashMap<String, AutoSuggestItem> itemMap = (HashMap<String, AutoSuggestItem>)this.getStateHelper().get((Serializable)((Object)ITEM_MAP_KEY));
            if (itemMap == null) {
                itemMap = new HashMap<String, AutoSuggestItem>();
                this.getStateHelper().put((Serializable)((Object)ITEM_MAP_KEY), itemMap);
            }
            for (AutoSuggestItem item : suggestItems.getItems()) {
                if (itemMap.containsKey(item.getValue())) continue;
                itemMap.put(item.getValue(), item);
            }
        }
        return suggestItems;
    }

    public boolean isSelect2() {
        return this.getParent() instanceof UISelectManyBox || this.getParent() instanceof UISelectOneChoice;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AutoSuggestItems createAutoSuggestItems(Object object) {
        if (object instanceof AutoSuggestItems) {
            return (AutoSuggestItems)object;
        }
        AutoSuggestItems autoSuggestItems = new AutoSuggestItems();
        if (object instanceof List && !((List)object).isEmpty()) {
            if (((List)object).get(0) instanceof AutoSuggestItem) {
                autoSuggestItems.setItems((List)object);
                return autoSuggestItems;
            } else {
                if (!(((List)object).get(0) instanceof String)) throw new ClassCastException("Can't create AutoSuggestItems from '" + object + "'. Elements needs to be " + String.class.getName() + " or " + AutoSuggestItem.class.getName());
                ArrayList<AutoSuggestItem> items = new ArrayList<AutoSuggestItem>(((List)object).size());
                for (int i = 0; i < ((List)object).size(); ++i) {
                    AutoSuggestItem item = new AutoSuggestItem();
                    item.setLabel((String)((List)object).get(i));
                    item.setValue((String)((List)object).get(i));
                    items.add(item);
                }
                autoSuggestItems.setItems(items);
            }
            return autoSuggestItems;
        } else {
            autoSuggestItems.setItems(Collections.emptyList());
        }
        return autoSuggestItems;
    }

    public SelectItem getSelectItem(FacesContext facesContext, Object value, Converter converter) {
        String id;
        AutoSuggestItem autoSuggestItem;
        Map itemMap = (Map)this.getStateHelper().get((Serializable)((Object)ITEM_MAP_KEY));
        if (itemMap != null && (autoSuggestItem = (AutoSuggestItem)itemMap.get(id = converter != null ? converter.getAsString(facesContext, this.getParent(), value) : (String)value)) != null) {
            return new SelectItem(value, autoSuggestItem.getLabel());
        }
        return null;
    }

    public abstract void setDelay(Integer var1);

    public abstract void setMinimumCharacters(Integer var1);

    public abstract void setFilter(SuggestFilter var1);

    public abstract Integer getMinimumCharacters();
}

