/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.connectionManager;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.myfaces.orchestra.connectionManager.DisconnectableConnection;
import org.apache.myfaces.orchestra.connectionManager.DisconnectableConnectionFactory;

public class ConnectionManagerDataSource
implements DataSource {
    private DataSource dataSource;
    private String jndiName;
    private static ThreadLocal borrowedConnections = new ThreadLocal(){

        protected Object initialValue() {
            return new HashSet();
        }
    };

    void onAfterBorrowConnection(Connection con) {
        ((Set)borrowedConnections.get()).add(con);
    }

    void onAfterReleaseConnection(Connection con) {
        ((Set)borrowedConnections.get()).remove(con);
    }

    public static void releaseAllBorrowedConnections() {
        DisconnectableConnection[] connections = new DisconnectableConnection[((Set)borrowedConnections.get()).size()];
        ((Set)borrowedConnections.get()).toArray(connections);
        for (int i = 0; i < connections.length; ++i) {
            DisconnectableConnection connection = connections[i];
            connection.disconnect();
        }
        ((Set)borrowedConnections.get()).clear();
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        try {
            InitialContext ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup(this.jndiName);
        }
        catch (NamingException e) {
            throw (IllegalArgumentException)new IllegalArgumentException(this.jndiName).initCause(e);
        }
        return this.dataSource;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public Connection getConnection() throws SQLException {
        return DisconnectableConnectionFactory.create(this);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.getDataSource().getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getDataSource().setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.getDataSource().setLoginTimeout(seconds);
    }

    public int getLoginTimeout() throws SQLException {
        return this.getDataSource().getLoginTimeout();
    }

    public Object unwrap(Class iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

