/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.orchestra.lib.jsf;

import javax.faces.FacesException;
import javax.faces.context.FacesContext;

import org.apache.myfaces.orchestra.conversation.ConversationManager;

/**
 * RequestHandler that simply ensures that a ConversationManager exists for the current user
 * at the start of a request.
 * <p>
 * However if there is no session then one is not created, as that would force the creation
 * of a session to store it in. Creating the session is particularly unfriendly for apps
 * that use weblets and disable cookies..
 * 
 * @since 1.1
 */
class ConversationManagerRequestHandler implements RequestHandler
{
    public void init(FacesContext facesContext) throws FacesException
    {
        Object session = facesContext.getExternalContext().getSession(false);
        if (session != null)
        {
            ConversationManager.getInstance();
        }
    }

    public void deinit() throws FacesException
    {
    }
}

