/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.beanval.interceptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.BeanValidator;
import javax.faces.validator.Validator;
import org.apache.myfaces.extensions.validator.beanval.ExtValBeanValidationContext;
import org.apache.myfaces.extensions.validator.beanval.interceptor.ExtValBeanValidator;
import org.apache.myfaces.extensions.validator.core.interceptor.PropertyValidationInterceptor;
import org.apache.myfaces.extensions.validator.core.property.PropertyInformation;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class BeanValidationTagAwareValidationInterceptor
implements PropertyValidationInterceptor {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());

    public boolean beforeValidation(FacesContext facesContext, UIComponent uiComponent, Object convertedObject, Map<String, Object> properties) {
        if (uiComponent instanceof EditableValueHolder && properties.containsKey(PropertyInformation.class.getName())) {
            this.inspectValidators(facesContext.getViewRoot().getViewId(), (EditableValueHolder)uiComponent, uiComponent.getClientId(facesContext), ((EditableValueHolder)uiComponent).getValidators());
        }
        return true;
    }

    public void afterValidation(FacesContext facesContext, UIComponent uiComponent, Object convertedObject, Map<String, Object> properties) {
    }

    @ToDo.List(value={@ToDo(value=Priority.HIGH, description="optimize"), @ToDo(value=Priority.HIGH, description="use reflection instead of BeanValidator for jsf 1.x versions"), @ToDo(value=Priority.HIGH, description="test")})
    private void inspectValidators(String viewId, EditableValueHolder editableValueHolder, String clientId, Validator[] validators) {
        ArrayList<String> groupsClassNamesOfTagList = new ArrayList<String>();
        for (Validator validator : validators) {
            if (!(validator instanceof BeanValidator)) continue;
            if (((BeanValidator)validator).getValidationGroups() != null) {
                groupsClassNamesOfTagList.addAll(Arrays.asList(((BeanValidator)validator).getValidationGroups().split(",")));
            }
            if (!validator.getClass().getName().equals(BeanValidator.class.getName())) continue;
            editableValueHolder.removeValidator(validator);
            editableValueHolder.addValidator((Validator)new ExtValBeanValidator(((BeanValidator)validator).getValidationGroups()));
        }
        ExtValBeanValidationContext beanValidationContext = ExtValBeanValidationContext.getCurrentInstance();
        for (String groupClassName : groupsClassNamesOfTagList) {
            Class currentClass = ClassUtils.tryToLoadClassForName((String)groupClassName.trim());
            if (currentClass != null && currentClass.isInterface()) {
                beanValidationContext.addGroup(currentClass, viewId, clientId);
                continue;
            }
            this.logger.severe(groupClassName + " is no valid group - only existing interfaces are allowed");
        }
    }
}

