/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core;

import org.apache.myfaces.extensions.validator.core.validation.strategy.ValidationStrategy;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class InternalConventionProvider {
    public static String getModuleMessageBundleName(String packageName) {
        String newPackageName = packageName.endsWith(".resolver") ? packageName.replace(".resolver", ".bundle") : packageName.replace(".resolver.", ".bundle.");
        return newPackageName + ".validation_messages";
    }

    @ToDo(value=Priority.MEDIUM, description="logging")
    public static String getMessageResolverClassName(Class<? extends ValidationStrategy> validationStrategyClass, String targetClassName) {
        return InternalConventionProvider.getValidationStrategyBasedName(validationStrategyClass, ".message.resolver.", targetClassName);
    }

    public static String getMetaDataTransformerClassName(Class<? extends ValidationStrategy> validationStrategyClass, String targetClassName) {
        return InternalConventionProvider.getValidationStrategyBasedName(validationStrategyClass, ".metadata.transformer.", targetClassName);
    }

    private static String getValidationStrategyBasedName(Class<? extends ValidationStrategy> validationStrategyClass, String targetPackageName, String targetClassName) {
        String validationStrategyClassName = validationStrategyClass.getName();
        validationStrategyClassName = validationStrategyClassName.replace(".strategy.", targetPackageName);
        if (targetClassName == null || validationStrategyClassName.lastIndexOf(".") == -1) {
            return null;
        }
        return validationStrategyClassName.substring(0, validationStrategyClassName.lastIndexOf(".")) + "." + targetClassName;
    }

    public static String getMessageResolverClassName(String validationStrategyName) {
        return InternalConventionProvider.getValidationStrategyBasedName(validationStrategyName, "ValidationErrorMessageResolver");
    }

    public static String getValidationStrategyClassName(String metaDataKey) {
        return metaDataKey.replace(".annotation.", ".strategy.") + "Strategy";
    }

    public static String getMetaDataTransformerClassName(String validationStrategyName) {
        return InternalConventionProvider.getValidationStrategyBasedName(validationStrategyName, "MetaDataTransformer");
    }

    public static String getValidationStrategyBasedName(String validationStrategyName, String targetPostfix) {
        if (validationStrategyName.endsWith("ValidationStrategy")) {
            return validationStrategyName.substring(0, validationStrategyName.length() - 18) + targetPostfix;
        }
        if (validationStrategyName.endsWith("Strategy")) {
            return validationStrategyName.substring(0, validationStrategyName.length() - 8) + targetPostfix;
        }
        return validationStrategyName + targetPostfix;
    }
}

