/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.baseval.strategy;

import java.lang.annotation.Annotation;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import org.apache.myfaces.extensions.validator.core.metadata.MetaDataEntry;
import org.apache.myfaces.extensions.validator.core.validation.EmptyValueAwareValidationStrategy;
import org.apache.myfaces.extensions.validator.core.validation.NullValueAwareValidationStrategy;
import org.apache.myfaces.extensions.validator.core.validation.exception.RequiredValidatorException;
import org.apache.myfaces.extensions.validator.core.validation.strategy.AbstractAnnotationValidationStrategy;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

@NullValueAwareValidationStrategy
@EmptyValueAwareValidationStrategy
@UsageInformation(value={UsageCategory.INTERNAL})
public class JpaValidationStrategy
extends AbstractAnnotationValidationStrategy {
    private boolean useFacesBundle = false;
    private static final String VALIDATE_LENGTH = "length";
    private String violation;
    private int maxLength;

    public void processValidation(FacesContext facesContext, UIComponent uiComponent, MetaDataEntry metaDataEntry, Object convertedObject) throws ValidatorException {
        Annotation annotation = (Annotation)metaDataEntry.getValue(Annotation.class);
        if (annotation instanceof Column) {
            this.validateColumnAnnotation((Column)annotation, convertedObject);
        } else if (annotation instanceof Basic) {
            this.validateBasicAnnotation((Basic)annotation, convertedObject);
        } else if (annotation instanceof Id) {
            this.checkRequiredConvertedObject(convertedObject);
        } else if (annotation instanceof OneToOne) {
            this.validateOneToOneAnnotation((OneToOne)annotation, convertedObject);
        } else if (annotation instanceof ManyToOne) {
            this.validateManyToOneAnnotation((ManyToOne)annotation, convertedObject);
        }
    }

    private void validateColumnAnnotation(Column column, Object convertedObject) throws ValidatorException {
        if (!column.nullable()) {
            this.checkRequiredConvertedObject(convertedObject);
        }
        if (convertedObject == null) {
            return;
        }
        if (convertedObject instanceof String && column.length() < ((String)convertedObject).length()) {
            this.violation = VALIDATE_LENGTH;
            this.maxLength = column.length();
            throw new ValidatorException(this.getValidationErrorFacesMessage(null));
        }
    }

    private void validateBasicAnnotation(Basic basic, Object convertedObject) throws ValidatorException {
        if (!basic.optional()) {
            this.checkRequiredConvertedObject(convertedObject);
        }
    }

    private void validateOneToOneAnnotation(OneToOne oneToOne, Object convertedObject) {
        if (!oneToOne.optional()) {
            this.checkRequiredConvertedObject(convertedObject);
        }
    }

    private void validateManyToOneAnnotation(ManyToOne manyToOne, Object convertedObject) {
        if (!manyToOne.optional()) {
            this.checkRequiredConvertedObject(convertedObject);
        }
    }

    @ToDo(value=Priority.MEDIUM)
    private void checkRequiredConvertedObject(Object convertedObject) throws ValidatorException {
        if (convertedObject == null || "".equals(convertedObject) && ExtValUtils.interpretEmptyStringValuesAsNull()) {
            this.violation = "required";
            throw new RequiredValidatorException(this.getValidationErrorFacesMessage(null));
        }
    }

    protected String getValidationErrorMsgKey(Annotation annotation) {
        if (VALIDATE_LENGTH.equals(this.violation)) {
            return "field_too_long";
        }
        return "field_required";
    }

    protected String getErrorMessageDetail(Annotation annotation) {
        String message = super.getErrorMessageDetail(annotation);
        if (VALIDATE_LENGTH.equals(this.violation)) {
            return message.replace("{0}", "" + this.maxLength);
        }
        return message;
    }

    protected String resolveMessage(String key) {
        String result = super.resolveMessage(key);
        String marker = "???";
        if ((marker + key + marker).equals(result)) {
            this.useFacesBundle = true;
        }
        return result;
    }

    protected boolean processAfterValidatorException(FacesContext facesContext, UIComponent uiComponent, MetaDataEntry metaDataEntry, Object convertedObject, ValidatorException e) {
        FacesMessage facesMessage = e.getFacesMessage();
        if (this.useFacesBundle) {
            if (VALIDATE_LENGTH.equals(this.violation)) {
                ExtValUtils.replaceWithDefaultMaximumMessage((FacesMessage)facesMessage, (int)this.maxLength);
            } else {
                ExtValUtils.replaceWithDefaultRequiredMessage((FacesMessage)facesMessage);
            }
        }
        return super.processAfterValidatorException(facesContext, uiComponent, metaDataEntry, convertedObject, e);
    }
}

