/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import jakarta.faces.FacesException;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.faces.lifecycle.LifecycleFactory;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.myfaces.lifecycle.LifecycleImpl;

public class LifecycleFactoryImpl
extends LifecycleFactory {
    private final Map<String, Lifecycle> _lifecycles = new ConcurrentHashMap<String, Lifecycle>(3, 1.0f);

    public LifecycleFactoryImpl() {
        this.addLifecycle("DEFAULT", new LifecycleImpl());
    }

    public void purgeLifecycle() {
        this._lifecycles.clear();
        this.addLifecycle("DEFAULT", new LifecycleImpl());
    }

    @Override
    public void addLifecycle(String id, Lifecycle lifecycle) {
        if (this._lifecycles.get(id) != null) {
            throw new IllegalArgumentException("Lifecycle with id '" + id + "' already exists.");
        }
        this._lifecycles.put(id, lifecycle);
    }

    @Override
    public Lifecycle getLifecycle(String id) throws FacesException {
        Lifecycle lifecycle = this._lifecycles.get(id);
        if (lifecycle == null) {
            throw new IllegalArgumentException("Unknown lifecycle '" + id + "'.");
        }
        return lifecycle;
    }

    @Override
    public Iterator<String> getLifecycleIds() {
        return this._lifecycles.keySet().iterator();
    }
}

