/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.servlet;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.lifecycle.ClientWindow;
import jakarta.servlet.ServletContext;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.context.ReleaseableExternalContext;
import org.apache.myfaces.context.servlet.ApplicationMap;
import org.apache.myfaces.context.servlet.InitParameterMap;

public abstract class ServletExternalContextImplBase
extends ExternalContext
implements ReleaseableExternalContext {
    private static final String INIT_PARAMETER_MAP_ATTRIBUTE = InitParameterMap.class.getName();
    private ServletContext _servletContext;
    private Map<String, Object> _applicationMap;
    private Map<String, String> _initParameterMap;
    private ClientWindow _clientWindow;

    public ServletExternalContextImplBase(ServletContext servletContext) {
        this._servletContext = servletContext;
        this._applicationMap = null;
        this._initParameterMap = null;
        this._clientWindow = null;
    }

    @Override
    public void release() {
        this._servletContext = null;
        this._applicationMap = null;
        this._initParameterMap = null;
        this._clientWindow = null;
    }

    @Override
    public Map<String, Object> getApplicationMap() {
        if (this._applicationMap == null) {
            this._applicationMap = new ApplicationMap(this._servletContext);
        }
        return this._applicationMap;
    }

    @Override
    public String getMimeType(String file) {
        this.checkNull(file, "file");
        return this._servletContext.getMimeType(file);
    }

    @Override
    public Object getContext() {
        return this._servletContext;
    }

    @Override
    public String getContextName() {
        return this._servletContext.getServletContextName();
    }

    @Override
    public String getInitParameter(String s) {
        if (s == null) {
            throw new NullPointerException("Init parameter name cannot be null");
        }
        return this._servletContext.getInitParameter(s);
    }

    @Override
    public Map<String, String> getInitParameterMap() {
        if (this._initParameterMap == null) {
            this._initParameterMap = (Map)this._servletContext.getAttribute(INIT_PARAMETER_MAP_ATTRIBUTE);
            if (this._initParameterMap == null) {
                this._initParameterMap = new InitParameterMap(this._servletContext);
                this._servletContext.setAttribute(INIT_PARAMETER_MAP_ATTRIBUTE, this._initParameterMap);
            }
        }
        return this._initParameterMap;
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        this.checkNull(path, "path");
        return this._servletContext.getResource(path);
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        this.checkNull(path, "path");
        return this._servletContext.getResourceAsStream(path);
    }

    @Override
    public Set<String> getResourcePaths(String path) {
        this.checkNull(path, "path");
        return this._servletContext.getResourcePaths(path);
    }

    @Override
    public void log(String message) {
        this.checkNull(message, "message");
        this._servletContext.log(message);
    }

    @Override
    public void log(String message, Throwable exception) {
        this.checkNull(message, "message");
        this.checkNull(exception, "exception");
        this._servletContext.log(message, exception);
    }

    @Override
    public String getRealPath(String path) {
        this.checkNull(path, "path");
        return this._servletContext.getRealPath(path);
    }

    @Override
    public ClientWindow getClientWindow() {
        return this._clientWindow;
    }

    @Override
    public void setClientWindow(ClientWindow window) {
        this._clientWindow = window;
    }

    @Override
    public String getApplicationContextPath() {
        return this._servletContext.getContextPath();
    }

    protected void checkNull(Object o, String param) {
        if (o == null) {
            throw new NullPointerException(param + " can not be null.");
        }
    }
}

