/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import jakarta.faces.FacesException;
import jakarta.faces.application.Resource;
import jakarta.faces.application.ResourceHandler;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.facelets.ComponentConfig;
import jakarta.faces.view.facelets.FaceletHandler;
import jakarta.faces.view.facelets.Tag;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.myfaces.config.element.facelets.FaceletBehaviorTag;
import org.apache.myfaces.config.element.facelets.FaceletComponentTag;
import org.apache.myfaces.config.element.facelets.FaceletConverterTag;
import org.apache.myfaces.config.element.facelets.FaceletFunction;
import org.apache.myfaces.config.element.facelets.FaceletHandlerTag;
import org.apache.myfaces.config.element.facelets.FaceletSourceTag;
import org.apache.myfaces.config.element.facelets.FaceletTag;
import org.apache.myfaces.config.element.facelets.FaceletTagDefinition;
import org.apache.myfaces.config.element.facelets.FaceletTagLibrary;
import org.apache.myfaces.config.element.facelets.FaceletValidatorTag;
import org.apache.myfaces.shared.util.ArrayUtils;
import org.apache.myfaces.shared.util.StringUtils;
import org.apache.myfaces.shared.util.WebConfigParamUtils;
import org.apache.myfaces.view.facelets.tag.AbstractTagLibrary;
import org.apache.myfaces.view.facelets.tag.TagLibrary;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentResourceTagHandler;
import org.apache.myfaces.view.facelets.tag.composite.CompositeResouceWrapper;
import org.apache.myfaces.view.facelets.util.ParameterCheck;
import org.apache.myfaces.view.facelets.util.ReflectionUtil;

public final class TagLibraryConfig {
    protected static final Logger log = Logger.getLogger(TagLibraryConfig.class.getName());

    public static TagLibrary create(FacesContext facesContext, FaceletTagLibrary faceletTagLibrary) {
        if (TagLibraryConfig.isNotEmpty(faceletTagLibrary.getLibraryClass())) {
            TagLibrary t = null;
            try {
                Class<TagLibrary> type = TagLibraryConfig.createClass(TagLibrary.class, faceletTagLibrary.getLibraryClass());
                t = type.newInstance();
            }
            catch (Exception ex) {
                throw new FacesException("Cannot instantiate TagLibrary", (Throwable)ex);
            }
            return t;
        }
        TagLibraryImpl impl = new TagLibraryImpl(facesContext, faceletTagLibrary.getNamespace());
        impl.setCompositeLibrary(faceletTagLibrary.getCompositeLibraryName());
        for (FaceletFunction ff : faceletTagLibrary.getFunctions()) {
            try {
                Class<Object> functionClass = TagLibraryConfig.createClass(Object.class, ff.getFunctionClass());
                impl.putFunction(ff.getFunctionName(), TagLibraryConfig.createMethod(functionClass, ff.getFunctionSignature()));
            }
            catch (Exception ex) {
                throw new FacesException("Cannot instantiate Function Class", (Throwable)ex);
            }
        }
        for (FaceletTag ft : faceletTagLibrary.getTags()) {
            try {
                Class<TagHandler> handlerClass;
                FaceletTagDefinition tag;
                if (ft.isHandlerTag()) {
                    tag = (FaceletHandlerTag)ft.getTagDefinition();
                    if (((FaceletHandlerTag)tag).getHandlerClass() == null) continue;
                    handlerClass = TagLibraryConfig.createClass(TagHandler.class, ((FaceletHandlerTag)tag).getHandlerClass());
                    impl.putTagHandler(ft.getName(), handlerClass);
                    continue;
                }
                if (ft.isComponentTag()) {
                    tag = (FaceletComponentTag)ft.getTagDefinition();
                    if (((FaceletComponentTag)tag).getHandlerClass() != null) {
                        handlerClass = TagLibraryConfig.createClass(TagHandler.class, ((FaceletComponentTag)tag).getHandlerClass());
                        impl.putComponent(ft.getName(), ((FaceletComponentTag)tag).getComponentType(), ((FaceletComponentTag)tag).getRendererType(), handlerClass);
                        continue;
                    }
                    if (((FaceletComponentTag)tag).getResourceId() != null) {
                        impl.putComponentFromResourceId(ft.getName(), ((FaceletComponentTag)tag).getResourceId());
                        continue;
                    }
                    impl.putComponent(ft.getName(), ((FaceletComponentTag)tag).getComponentType(), ((FaceletComponentTag)tag).getRendererType());
                    continue;
                }
                if (ft.isSourceTag()) {
                    tag = (FaceletSourceTag)ft.getTagDefinition();
                    impl.putUserTag(ft.getName(), new URL(((FaceletSourceTag)tag).getSource()));
                    continue;
                }
                if (ft.isConverterTag()) {
                    tag = (FaceletConverterTag)ft.getTagDefinition();
                    if (((FaceletConverterTag)tag).getHandlerClass() != null) {
                        handlerClass = TagLibraryConfig.createClass(TagHandler.class, ((FaceletConverterTag)tag).getHandlerClass());
                        impl.putConverter(ft.getName(), ((FaceletConverterTag)tag).getConverterId(), handlerClass);
                        continue;
                    }
                    impl.putConverter(ft.getName(), ((FaceletConverterTag)tag).getConverterId());
                    continue;
                }
                if (ft.isValidatorTag()) {
                    tag = (FaceletValidatorTag)ft.getTagDefinition();
                    if (((FaceletValidatorTag)tag).getHandlerClass() != null) {
                        handlerClass = TagLibraryConfig.createClass(TagHandler.class, ((FaceletValidatorTag)tag).getHandlerClass());
                        impl.putValidator(ft.getName(), ((FaceletValidatorTag)tag).getValidatorId(), handlerClass);
                        continue;
                    }
                    impl.putValidator(ft.getName(), ((FaceletValidatorTag)tag).getValidatorId());
                    continue;
                }
                if (!ft.isBehaviorTag()) continue;
                tag = (FaceletBehaviorTag)ft.getTagDefinition();
                if (((FaceletBehaviorTag)tag).getHandlerClass() != null) {
                    handlerClass = TagLibraryConfig.createClass(TagHandler.class, ((FaceletBehaviorTag)tag).getHandlerClass());
                    impl.putBehavior(ft.getName(), ((FaceletBehaviorTag)tag).getBehaviorId(), handlerClass);
                    continue;
                }
                impl.putBehavior(ft.getName(), ((FaceletBehaviorTag)tag).getBehaviorId());
            }
            catch (Exception ex) {
                throw new FacesException("Cannot instantiate Tag " + ft.getName() + " from namespace " + faceletTagLibrary.getNamespace(), (Throwable)ex);
            }
        }
        return impl;
    }

    private static <T> Class<? extends T> createClass(Class<T> type, String name) throws Exception {
        Class<?> factory = ReflectionUtil.forName(name);
        if (!type.isAssignableFrom(factory)) {
            throw new Exception(name + " must be an instance of " + type.getName());
        }
        return factory;
    }

    private static Method createMethod(Class<?> type, String s) throws Exception {
        Class[] pc;
        int pos = s.indexOf(32);
        if (pos == -1) {
            throw new Exception("Must Provide Return Type: " + s);
        }
        int pos2 = s.indexOf(40, pos + 1);
        if (pos2 == -1) {
            throw new Exception("Must provide a method name, followed by '(': " + s);
        }
        String mn = s.substring(pos + 1, pos2).trim();
        pos = s.indexOf(41, pos2 + 1);
        if (pos == -1) {
            throw new Exception("Must close parentheses, ')' missing: " + s);
        }
        String[] ps = s.substring(pos2 + 1, pos).trim().split(",");
        if (ps.length == 1 && "".equals(ps[0])) {
            pc = new Class[]{};
        } else {
            pc = new Class[ps.length];
            for (int i = 0; i < pc.length; ++i) {
                pc[i] = ReflectionUtil.forName(ps[i].trim());
            }
        }
        try {
            return type.getMethod(mn, pc);
        }
        catch (NoSuchMethodException e) {
            throw new Exception("No Function Found on type: " + type.getName() + " with signature: " + s);
        }
    }

    private static boolean isNotEmpty(String value) {
        return value != null && value.length() > 0;
    }

    private static class ComponentConfigWrapper
    implements ComponentConfig {
        protected final TagConfig parent;
        protected final String componentType;
        protected final String rendererType;

        public ComponentConfigWrapper(TagConfig parent, String componentType, String rendererType) {
            this.parent = parent;
            this.componentType = componentType;
            this.rendererType = rendererType;
        }

        public String getComponentType() {
            return this.componentType;
        }

        public String getRendererType() {
            return this.rendererType;
        }

        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        public Tag getTag() {
            return this.parent.getTag();
        }

        public String getTagId() {
            return this.parent.getTagId();
        }
    }

    private static class TagLibraryImpl
    extends AbstractTagLibrary {
        private String _compositeLibraryName = null;
        private final ResourceHandler _resourceHandler;
        private Pattern _acceptPatterns;
        private String _extension;
        private String[] _defaultSuffixesArray;

        public TagLibraryImpl(FacesContext facesContext, String namespace) {
            super(namespace);
            this._resourceHandler = facesContext.getApplication().getResourceHandler();
            ExternalContext externalContext = facesContext.getExternalContext();
            this._acceptPatterns = this.loadAcceptPattern(externalContext);
            this._extension = this.loadFaceletExtension(externalContext);
            String defaultSuffixes = WebConfigParamUtils.getStringInitParameter(externalContext, "jakarta.faces.DEFAULT_SUFFIX", ".xhtml .view.xml .jsp");
            this._defaultSuffixesArray = StringUtils.splitShortString(defaultSuffixes, ' ');
            boolean faceletsExtensionFound = false;
            for (String ext : this._defaultSuffixesArray) {
                if (!this._extension.equals(ext)) continue;
                faceletsExtensionFound = true;
                break;
            }
            if (!faceletsExtensionFound) {
                this._defaultSuffixesArray = (String[])ArrayUtils.concat(this._defaultSuffixesArray, new String[]{this._extension});
            }
        }

        private Pattern loadAcceptPattern(ExternalContext context) {
            assert (context != null);
            String mappings = context.getInitParameter("jakarta.faces.FACELETS_VIEW_MAPPINGS");
            if (mappings == null) {
                return null;
            }
            if ((mappings = mappings.trim()).length() == 0) {
                return null;
            }
            return Pattern.compile(this.toRegex(mappings));
        }

        private String loadFaceletExtension(ExternalContext context) {
            assert (context != null);
            String suffix = context.getInitParameter("jakarta.faces.FACELETS_SUFFIX");
            if (suffix == null) {
                suffix = ".xhtml";
            } else if ((suffix = suffix.trim()).length() == 0) {
                suffix = ".xhtml";
            }
            return suffix;
        }

        private String toRegex(String mappings) {
            assert (mappings != null);
            mappings = mappings.replaceAll("\\s", "");
            mappings = mappings.replaceAll("\\.", "\\\\.");
            mappings = mappings.replaceAll("\\*", ".*");
            mappings = mappings.replaceAll(";", "|");
            return mappings;
        }

        public boolean handles(String resourceName) {
            if (resourceName == null) {
                return false;
            }
            if (resourceName.endsWith(this._extension)) {
                return true;
            }
            return this._acceptPatterns != null && this._acceptPatterns.matcher(resourceName).matches();
        }

        @Override
        public boolean containsTagHandler(String ns, String localName) {
            boolean result = super.containsTagHandler(ns, localName);
            if (!result && this._compositeLibraryName != null && this.containsNamespace(ns)) {
                for (String defaultSuffix : this._defaultSuffixesArray) {
                    Resource compositeComponentResource;
                    String resourceName = localName + defaultSuffix;
                    if (!this.handles(resourceName) || (compositeComponentResource = this._resourceHandler.createResource(resourceName, this._compositeLibraryName)) == null) continue;
                    URL url = compositeComponentResource.getURL();
                    return url != null;
                }
            }
            return result;
        }

        @Override
        public TagHandler createTagHandler(String ns, String localName, TagConfig tag) throws FacesException {
            TagHandler tagHandler = super.createTagHandler(ns, localName, tag);
            if (tagHandler == null && this._compositeLibraryName != null && this.containsNamespace(ns)) {
                for (String defaultSuffix : this._defaultSuffixesArray) {
                    CompositeResouceWrapper compositeComponentResource;
                    String resourceName = localName + defaultSuffix;
                    if (!this.handles(resourceName) || (compositeComponentResource = new CompositeResouceWrapper(this._resourceHandler.createResource(resourceName, this._compositeLibraryName))) == null) continue;
                    ComponentConfigWrapper componentConfig = new ComponentConfigWrapper(tag, "jakarta.faces.NamingContainer", null);
                    return new CompositeComponentResourceTagHandler(componentConfig, compositeComponentResource);
                }
            }
            return tagHandler;
        }

        public void setCompositeLibrary(String compositeLibraryName) {
            this._compositeLibraryName = compositeLibraryName;
        }

        public void putConverter(String name, String id) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("id", id);
            this.addConverter(name, id);
        }

        public void putConverter(String name, String id, Class<? extends TagHandler> handlerClass) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("id", id);
            ParameterCheck.notNull("handlerClass", handlerClass);
            this.addConverter(name, id, handlerClass);
        }

        public void putValidator(String name, String id) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("id", id);
            this.addValidator(name, id);
        }

        public void putValidator(String name, String id, Class<? extends TagHandler> handlerClass) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("id", id);
            ParameterCheck.notNull("handlerClass", handlerClass);
            this.addValidator(name, id, handlerClass);
        }

        public void putTagHandler(String name, Class<? extends TagHandler> type) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("type", type);
            this.addTagHandler(name, type);
        }

        public void putComponentFromResourceId(String name, String resourceId) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("resourceId", resourceId);
            this.addComponentFromResourceId(name, resourceId);
        }

        public void putComponent(String name, String componentType, String rendererType) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("componentType", componentType);
            this.addComponent(name, componentType, rendererType);
        }

        public void putComponent(String name, String componentType, String rendererType, Class<? extends TagHandler> handlerClass) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("componentType", componentType);
            ParameterCheck.notNull("handlerClass", handlerClass);
            this.addComponent(name, componentType, rendererType, handlerClass);
        }

        public void putUserTag(String name, URL source) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("source", source);
            this.addUserTag(name, source);
        }

        public void putFunction(String name, Method method) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("method", method);
            this.addFunction(name, method);
        }

        public void putBehavior(String name, String id) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("id", id);
            this.addBehavior(name, id);
        }

        public void putBehavior(String name, String id, Class<? extends TagHandler> handlerClass) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("id", id);
            ParameterCheck.notNull("handlerClass", handlerClass);
            this.addBehavior(name, id, handlerClass);
        }
    }
}

