/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.validator;

import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.Validator;
import jakarta.faces.validator.ValidatorException;
import jakarta.faces.validator._MessageUtils;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexValidator
implements Validator,
PartialStateHolder {
    public static final String VALIDATOR_ID = "jakarta.faces.RegularExpression";
    public static final String PATTERN_NOT_SET_MESSAGE_ID = "jakarta.faces.validator.RegexValidator.PATTERN_NOT_SET";
    public static final String NOT_MATCHED_MESSAGE_ID = "jakarta.faces.validator.RegexValidator.NOT_MATCHED";
    public static final String MATCH_EXCEPTION_MESSAGE_ID = "jakarta.faces.validator.RegexValidator.MATCH_EXCEPTION";
    private static final String EMPTY_STRING = "";
    private String pattern;
    private boolean isTransient = false;
    private boolean _initialStateMarked = false;

    public void validate(FacesContext context, UIComponent component, Object value) {
        Pattern thePattern;
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        if (value == null) {
            return;
        }
        if (!(value instanceof String)) {
            throw new ValidatorException(_MessageUtils.getErrorMessage(context, NOT_MATCHED_MESSAGE_ID, null));
        }
        String string = (String)value;
        if (this.pattern == null || this.pattern.equals(EMPTY_STRING)) {
            throw new ValidatorException(_MessageUtils.getErrorMessage(context, PATTERN_NOT_SET_MESSAGE_ID, null));
        }
        try {
            thePattern = Pattern.compile(this.pattern);
        }
        catch (PatternSyntaxException pse) {
            throw new ValidatorException(_MessageUtils.getErrorMessage(context, MATCH_EXCEPTION_MESSAGE_ID, null));
        }
        if (!thePattern.matcher(string).matches()) {
            Object[] args = new Object[]{thePattern, _MessageUtils.getLabel(context, component)};
            throw new ValidatorException(_MessageUtils.getErrorMessage(context, NOT_MATCHED_MESSAGE_ID, args));
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.initialStateMarked()) {
            return this.pattern;
        }
        return null;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (state != null) {
            this.pattern = (String)state;
        }
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.clearInitialState();
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void clearInitialState() {
        this._initialStateMarked = false;
    }

    @Override
    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    @Override
    public void markInitialState() {
        this._initialStateMarked = true;
    }

    private Boolean isDisabled() {
        return null;
    }

    private String getFor() {
        return null;
    }
}

