/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.push.cdi;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.push.PushContext;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.push.cdi.WebsocketApplicationBean;
import org.apache.myfaces.push.cdi.WebsocketApplicationSessionHolder;
import org.apache.myfaces.push.cdi.WebsocketSessionBean;
import org.apache.myfaces.push.cdi.WebsocketViewBean;

public class PushContextImpl
implements PushContext {
    private final String channel;

    public PushContextImpl(String channel) {
        this.channel = channel;
    }

    public String getChannel() {
        return this.channel;
    }

    public Set<Future<Void>> send(Object message) {
        List<String> channelTokens;
        String channel = this.getChannel();
        BeanManager beanManager = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        beanManager = facesContext != null ? CDIUtils.getBeanManager(facesContext.getExternalContext()) : CDI.current().getBeanManager();
        WebsocketApplicationBean appTokenBean = CDIUtils.get(beanManager, WebsocketApplicationBean.class, false, new Annotation[0]);
        WebsocketViewBean viewTokenBean = null;
        WebsocketSessionBean sessionTokenBean = null;
        if (CDIUtils.isSessionScopeActive(beanManager)) {
            sessionTokenBean = CDIUtils.get(beanManager, WebsocketSessionBean.class, false, new Annotation[0]);
            if (CDIUtils.isViewScopeActive(beanManager)) {
                viewTokenBean = CDIUtils.get(beanManager, WebsocketViewBean.class, false, new Annotation[0]);
            }
        }
        if (appTokenBean == null) {
            return Collections.emptySet();
        }
        if (viewTokenBean != null && viewTokenBean.isChannelAvailable(channel)) {
            channelTokens = viewTokenBean.getChannelTokensFor(channel);
        } else if (sessionTokenBean != null && sessionTokenBean.isChannelAvailable(this.getChannel())) {
            channelTokens = sessionTokenBean.getChannelTokensFor(channel);
        } else if (appTokenBean != null && appTokenBean.isChannelAvailable(this.getChannel())) {
            channelTokens = appTokenBean.getChannelTokensFor(channel);
        } else {
            throw new FacesException("CDI bean not found for push message");
        }
        if (channelTokens != null && !channelTokens.isEmpty()) {
            Set<Future<Void>> result = null;
            for (String channelToken : channelTokens) {
                if (result == null) {
                    result = WebsocketApplicationSessionHolder.send(channelToken, message);
                    continue;
                }
                result.addAll(WebsocketApplicationSessionHolder.send(channelToken, message));
            }
            return result;
        }
        return Collections.emptySet();
    }

    public <S extends Serializable> Set<Future<Void>> send(Object message, S user) {
        return this.send(message, Collections.singleton(user)).get(user);
    }

    public <S extends Serializable> Map<S, Set<Future<Void>>> send(Object message, Collection<S> users) {
        String channel = this.getChannel();
        BeanManager beanManager = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        beanManager = facesContext != null ? CDIUtils.getBeanManager(facesContext.getExternalContext()) : CDI.current().getBeanManager();
        WebsocketApplicationBean appTokenBean = CDIUtils.get(beanManager, WebsocketApplicationBean.class, false, new Annotation[0]);
        WebsocketViewBean viewTokenBean = null;
        WebsocketSessionBean sessionTokenBean = null;
        if (CDIUtils.isSessionScopeActive(beanManager)) {
            sessionTokenBean = CDIUtils.get(beanManager, WebsocketSessionBean.class, false, new Annotation[0]);
            if (CDIUtils.isViewScopeActive(beanManager)) {
                viewTokenBean = CDIUtils.get(beanManager, WebsocketViewBean.class, false, new Annotation[0]);
            }
        }
        if (appTokenBean == null) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, Set<Future<Void>>> result = new HashMap<Serializable, Set<Future<Void>>>();
        if (viewTokenBean != null && viewTokenBean.isChannelAvailable(channel)) {
            for (Serializable user : users) {
                result.put(user, this.send(viewTokenBean.getChannelTokensFor(channel, user), message));
            }
        } else if (sessionTokenBean != null && sessionTokenBean.isChannelAvailable(this.getChannel())) {
            for (Serializable user : users) {
                result.put(user, this.send(sessionTokenBean.getChannelTokensFor(channel, user), message));
            }
        } else if (appTokenBean != null && appTokenBean.isChannelAvailable(this.getChannel())) {
            for (Serializable user : users) {
                result.put(user, this.send(appTokenBean.getChannelTokensFor(channel, user), message));
            }
        } else {
            throw new FacesException("CDI bean not found for push message");
        }
        return result;
    }

    private Set<Future<Void>> send(List<String> channelTokens, Object message) {
        if (channelTokens != null && !channelTokens.isEmpty()) {
            Set<Future<Void>> result = null;
            for (int i = 0; i < channelTokens.size(); ++i) {
                String channelToken = channelTokens.get(i);
                if (result == null) {
                    result = WebsocketApplicationSessionHolder.send(channelToken, message);
                    continue;
                }
                result.addAll(WebsocketApplicationSessionHolder.send(channelToken, message));
            }
            return result;
        }
        return Collections.emptySet();
    }
}

