/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.impl;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.apache.myfaces.cdi.util.BeanProvider;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.cdi.view.ApplicationContextBean;
import org.apache.myfaces.cdi.view.ViewScopeBeanHolder;
import org.apache.myfaces.cdi.view.ViewScopeCDIMap;
import org.apache.myfaces.flow.cdi.FlowScopeBeanHolder;
import org.apache.myfaces.spi.ViewScopeProvider;

public class CDIManagedBeanHandlerImpl
extends ViewScopeProvider {
    private BeanManager beanManager;
    private ViewScopeBeanHolder viewScopeBeanHolder;
    private FlowScopeBeanHolder flowScopeBeanHolder;

    public CDIManagedBeanHandlerImpl() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        this.beanManager = CDIUtils.getBeanManager(externalContext);
        Object context = externalContext.getContext();
        if (context instanceof ServletContext) {
            ApplicationContextBean appBean = CDIUtils.lookup(this.beanManager, ApplicationContextBean.class);
            appBean.setServletContext((ServletContext)context);
        }
    }

    private ViewScopeBeanHolder getViewScopeBeanHolder() {
        if (this.viewScopeBeanHolder == null) {
            this.viewScopeBeanHolder = BeanProvider.getContextualReference(this.beanManager, ViewScopeBeanHolder.class, false, new Annotation[0]);
        }
        return this.viewScopeBeanHolder;
    }

    private FlowScopeBeanHolder getFlowScopeBeanHolder() {
        if (this.flowScopeBeanHolder == null) {
            this.flowScopeBeanHolder = BeanProvider.getContextualReference(this.beanManager, FlowScopeBeanHolder.class, false, new Annotation[0]);
        }
        return this.flowScopeBeanHolder;
    }

    @Override
    public Map<String, Object> createViewScopeMap(FacesContext facesContext, String viewScopeId) {
        return new ViewScopeCDIMap(facesContext, viewScopeId);
    }

    @Override
    public Map<String, Object> restoreViewScopeMap(FacesContext facesContext, String viewScopeId) {
        return new ViewScopeCDIMap(facesContext, viewScopeId);
    }

    @Override
    public String generateViewScopeId(FacesContext facesContext) {
        return this.getViewScopeBeanHolder().generateUniqueViewScopeId();
    }

    @Override
    public void onSessionDestroyed() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && facesContext.getExternalContext().getSession(false) != null) {
            if (this.isViewScopeBeanHolderCreated(facesContext)) {
                this.getViewScopeBeanHolder().destroyBeans();
            }
            if (this.isFlowScopeBeanHolderCreated(facesContext)) {
                this.getFlowScopeBeanHolder().destroyBeans();
            }
        }
    }

    private boolean isViewScopeBeanHolderCreated(FacesContext facesContext) {
        return facesContext.getExternalContext().getSessionMap().containsKey("oam.view.SCOPE.KEY");
    }

    private boolean isFlowScopeBeanHolderCreated(FacesContext facesContext) {
        return facesContext.getExternalContext().getSessionMap().containsKey("oam.flow.SCOPE.KEY");
    }

    @Override
    public void destroyViewScopeMap(FacesContext facesContext, String viewScopeId) {
        if (facesContext.getExternalContext().getSession(false) != null && this.isViewScopeBeanHolderCreated(facesContext)) {
            this.getViewScopeBeanHolder().destroyBeans(viewScopeId);
        }
    }
}

