/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdf.model.hdftypes;

import org.apache.poi.hdf.model.hdftypes.CharacterProperties;
import org.apache.poi.hdf.model.hdftypes.HDFType;
import org.apache.poi.hdf.model.hdftypes.ParagraphProperties;
import org.apache.poi.hdf.model.hdftypes.SectionProperties;
import org.apache.poi.hdf.model.hdftypes.StyleDescription;
import org.apache.poi.hdf.model.hdftypes.TableCellDescriptor;
import org.apache.poi.hdf.model.hdftypes.TableProperties;
import org.apache.poi.hdf.model.hdftypes.definitions.TCAbstractType;
import org.apache.poi.util.LittleEndian;

public class StyleSheet
implements HDFType {
    private static final int NIL_STYLE = 4095;
    private static final int PAP_TYPE = 1;
    private static final int CHP_TYPE = 2;
    private static final int SEP_TYPE = 4;
    private static final int TAP_TYPE = 5;
    StyleDescription _nilStyle = new StyleDescription();
    StyleDescription[] _styleDescriptions;

    public StyleSheet(byte[] styleSheet) {
        int x;
        short stshiLength = LittleEndian.getShort((byte[])styleSheet, (int)0);
        int stdCount = LittleEndian.getShort((byte[])styleSheet, (int)2);
        short baseLength = LittleEndian.getShort((byte[])styleSheet, (int)4);
        int[] rgftc = new int[]{LittleEndian.getInt((byte[])styleSheet, (int)14), LittleEndian.getInt((byte[])styleSheet, (int)18), LittleEndian.getInt((byte[])styleSheet, (int)22)};
        int offset = 0;
        this._styleDescriptions = new StyleDescription[stdCount];
        for (x = 0; x < stdCount; ++x) {
            int stdOffset = 2 + stshiLength + offset;
            short stdSize = LittleEndian.getShort((byte[])styleSheet, (int)stdOffset);
            if (stdSize > 0) {
                StyleDescription aStyle;
                byte[] std = new byte[stdSize];
                System.arraycopy(styleSheet, stdOffset += 2, std, 0, stdSize);
                this._styleDescriptions[x] = aStyle = new StyleDescription(std, baseLength, true);
            }
            offset += stdSize + 2;
        }
        for (x = 0; x < this._styleDescriptions.length; ++x) {
            if (this._styleDescriptions[x] == null) continue;
            this.createPap(x);
            this.createChp(x);
        }
    }

    private void createPap(int istd) {
        StyleDescription sd = this._styleDescriptions[istd];
        ParagraphProperties pap = sd.getPAP();
        byte[] papx = sd.getPAPX();
        int baseIndex = sd.getBaseStyle();
        if (pap == null && papx != null) {
            ParagraphProperties parentPAP = this._nilStyle.getPAP();
            if (baseIndex != 4095 && (parentPAP = this._styleDescriptions[baseIndex].getPAP()) == null) {
                this.createPap(baseIndex);
                parentPAP = this._styleDescriptions[baseIndex].getPAP();
            }
            pap = (ParagraphProperties)StyleSheet.uncompressProperty(papx, parentPAP, this);
            sd.setPAP(pap);
        }
    }

    private void createChp(int istd) {
        StyleDescription sd = this._styleDescriptions[istd];
        CharacterProperties chp = sd.getCHP();
        byte[] chpx = sd.getCHPX();
        int baseIndex = sd.getBaseStyle();
        if (chp == null && chpx != null) {
            CharacterProperties parentCHP = this._nilStyle.getCHP();
            if (baseIndex != 4095 && (parentCHP = this._styleDescriptions[baseIndex].getCHP()) == null) {
                this.createChp(baseIndex);
                parentCHP = this._styleDescriptions[baseIndex].getCHP();
            }
            chp = (CharacterProperties)StyleSheet.uncompressProperty(chpx, parentCHP, this);
            sd.setCHP(chp);
        }
    }

    public StyleDescription getStyleDescription(int x) {
        return this._styleDescriptions[x];
    }

    static void doCHPOperation(CharacterProperties oldCHP, CharacterProperties newCHP, int operand, int param, byte[] varParam, byte[] grpprl, int offset, StyleSheet styleSheet) {
        switch (operand) {
            case 0: {
                newCHP.setFRMarkDel(StyleSheet.getFlag(param));
                break;
            }
            case 1: {
                newCHP.setFRMark(StyleSheet.getFlag(param));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                newCHP.setFcPic(param);
                newCHP.setFSpec(true);
                break;
            }
            case 4: {
                newCHP.setIbstRMark((short)param);
                break;
            }
            case 5: {
                short[] dttmRMark = new short[]{LittleEndian.getShort((byte[])grpprl, (int)(offset - 4)), LittleEndian.getShort((byte[])grpprl, (int)(offset - 2))};
                newCHP.setDttmRMark(dttmRMark);
                break;
            }
            case 6: {
                newCHP.setFData(StyleSheet.getFlag(param));
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                short chsDiff = (short)((param & 0xFF0000) >>> 8);
                newCHP.setFChsDiff(StyleSheet.getFlag(chsDiff));
                newCHP.setChse((short)(param & 0xFFFF));
                break;
            }
            case 9: {
                newCHP.setFSpec(true);
                newCHP.setFtcSym(LittleEndian.getShort((byte[])varParam, (int)0));
                newCHP.setXchSym(LittleEndian.getShort((byte[])varParam, (int)2));
                break;
            }
            case 10: {
                newCHP.setFOle2(StyleSheet.getFlag(param));
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                newCHP.setIcoHighlight((byte)param);
                newCHP.setFHighlight(StyleSheet.getFlag(param));
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                newCHP.setFcObj(param);
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                break;
            }
            case 23: {
                break;
            }
            case 24: {
                break;
            }
            case 25: {
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                break;
            }
            case 35: {
                break;
            }
            case 36: {
                break;
            }
            case 37: {
                break;
            }
            case 38: {
                break;
            }
            case 39: {
                break;
            }
            case 40: {
                break;
            }
            case 41: {
                break;
            }
            case 42: {
                break;
            }
            case 43: {
                break;
            }
            case 44: {
                break;
            }
            case 45: {
                break;
            }
            case 46: {
                break;
            }
            case 47: {
                break;
            }
            case 48: {
                newCHP.setIstd(param);
                break;
            }
            case 49: {
                break;
            }
            case 50: {
                newCHP.setFBold(false);
                newCHP.setFItalic(false);
                newCHP.setFOutline(false);
                newCHP.setFStrike(false);
                newCHP.setFShadow(false);
                newCHP.setFSmallCaps(false);
                newCHP.setFCaps(false);
                newCHP.setFVanish(false);
                newCHP.setKul((byte)0);
                newCHP.setIco((byte)0);
                break;
            }
            case 51: {
                try {
                    newCHP = (CharacterProperties)oldCHP.clone();
                }
                catch (CloneNotSupportedException e) {
                    // empty catch block
                }
                return;
            }
            case 52: {
                break;
            }
            case 53: {
                newCHP.setFBold(StyleSheet.getCHPFlag((byte)param, oldCHP.isFBold()));
                break;
            }
            case 54: {
                newCHP.setFItalic(StyleSheet.getCHPFlag((byte)param, oldCHP.isFItalic()));
                break;
            }
            case 55: {
                newCHP.setFStrike(StyleSheet.getCHPFlag((byte)param, oldCHP.isFStrike()));
                break;
            }
            case 56: {
                newCHP.setFOutline(StyleSheet.getCHPFlag((byte)param, oldCHP.isFOutline()));
                break;
            }
            case 57: {
                newCHP.setFShadow(StyleSheet.getCHPFlag((byte)param, oldCHP.isFShadow()));
                break;
            }
            case 58: {
                newCHP.setFSmallCaps(StyleSheet.getCHPFlag((byte)param, oldCHP.isFSmallCaps()));
                break;
            }
            case 59: {
                newCHP.setFCaps(StyleSheet.getCHPFlag((byte)param, oldCHP.isFCaps()));
                break;
            }
            case 60: {
                newCHP.setFVanish(StyleSheet.getCHPFlag((byte)param, oldCHP.isFVanish()));
                break;
            }
            case 61: {
                newCHP.setFtcAscii((short)param);
                break;
            }
            case 62: {
                newCHP.setKul((byte)param);
                break;
            }
            case 63: {
                boolean fAdjust;
                byte hpsPos;
                byte cInc;
                int hps = param & 0xFF;
                if (hps != 0) {
                    newCHP.setHps(hps);
                }
                if ((cInc = (byte)((byte)(param & 0xFE00) >>> 4 >> 1)) != 0) {
                    newCHP.setHps(Math.max(newCHP.getHps() + cInc * 2, 2));
                }
                if ((hpsPos = (byte)((param & 0xFF0000) >>> 8)) != 128) {
                    newCHP.setHpsPos(hpsPos);
                }
                boolean bl = fAdjust = (param & 0x100) > 0;
                if (fAdjust && hpsPos != 128 && hpsPos != 0 && oldCHP.getHpsPos() == 0) {
                    newCHP.setHps(Math.max(newCHP.getHps() + -2, 2));
                }
                if (!fAdjust || hpsPos != 0 || oldCHP.getHpsPos() == 0) break;
                newCHP.setHps(Math.max(newCHP.getHps() + 2, 2));
                break;
            }
            case 64: {
                newCHP.setDxaSpace(param);
                break;
            }
            case 65: {
                newCHP.setLidDefault((short)param);
                break;
            }
            case 66: {
                newCHP.setIco((byte)param);
                break;
            }
            case 67: {
                newCHP.setHps(param);
                break;
            }
            case 68: {
                byte hpsLvl = (byte)param;
                newCHP.setHps(Math.max(newCHP.getHps() + hpsLvl * 2, 2));
                break;
            }
            case 69: {
                newCHP.setHpsPos((short)param);
                break;
            }
            case 70: {
                if (param != 0) {
                    if (oldCHP.getHpsPos() != 0) break;
                    newCHP.setHps(Math.max(newCHP.getHps() + -2, 2));
                    break;
                }
                if (oldCHP.getHpsPos() == 0) break;
                newCHP.setHps(Math.max(newCHP.getHps() + 2, 2));
                break;
            }
            case 71: {
                CharacterProperties genCHP = new CharacterProperties();
                genCHP.setFtcAscii(4);
                genCHP = (CharacterProperties)StyleSheet.uncompressProperty(varParam, genCHP, styleSheet);
                CharacterProperties styleCHP = styleSheet.getStyleDescription(oldCHP.getBaseIstd()).getCHP();
                if (genCHP.isFBold() == newCHP.isFBold()) {
                    newCHP.setFBold(styleCHP.isFBold());
                }
                if (genCHP.isFItalic() == newCHP.isFItalic()) {
                    newCHP.setFItalic(styleCHP.isFItalic());
                }
                if (genCHP.isFSmallCaps() == newCHP.isFSmallCaps()) {
                    newCHP.setFSmallCaps(styleCHP.isFSmallCaps());
                }
                if (genCHP.isFVanish() == newCHP.isFVanish()) {
                    newCHP.setFVanish(styleCHP.isFVanish());
                }
                if (genCHP.isFStrike() == newCHP.isFStrike()) {
                    newCHP.setFStrike(styleCHP.isFStrike());
                }
                if (genCHP.isFCaps() == newCHP.isFCaps()) {
                    newCHP.setFCaps(styleCHP.isFCaps());
                }
                if (genCHP.getFtcAscii() == newCHP.getFtcAscii()) {
                    newCHP.setFtcAscii(styleCHP.getFtcAscii());
                }
                if (genCHP.getFtcFE() == newCHP.getFtcFE()) {
                    newCHP.setFtcFE(styleCHP.getFtcFE());
                }
                if (genCHP.getFtcOther() == newCHP.getFtcOther()) {
                    newCHP.setFtcOther(styleCHP.getFtcOther());
                }
                if (genCHP.getHps() == newCHP.getHps()) {
                    newCHP.setHps(styleCHP.getHps());
                }
                if (genCHP.getHpsPos() == newCHP.getHpsPos()) {
                    newCHP.setHpsPos(styleCHP.getHpsPos());
                }
                if (genCHP.getKul() == newCHP.getKul()) {
                    newCHP.setKul(styleCHP.getKul());
                }
                if (genCHP.getDxaSpace() == newCHP.getDxaSpace()) {
                    newCHP.setDxaSpace(styleCHP.getDxaSpace());
                }
                if (genCHP.getIco() == newCHP.getIco()) {
                    newCHP.setIco(styleCHP.getIco());
                }
                if (genCHP.getLidDefault() == newCHP.getLidDefault()) {
                    newCHP.setLidDefault(styleCHP.getLidDefault());
                }
                if (genCHP.getLidFE() != newCHP.getLidFE()) break;
                newCHP.setLidFE(styleCHP.getLidFE());
                break;
            }
            case 72: {
                newCHP.setIss((byte)param);
                break;
            }
            case 73: {
                newCHP.setHps(LittleEndian.getShort((byte[])varParam, (int)0));
                break;
            }
            case 74: {
                short increment = LittleEndian.getShort((byte[])varParam, (int)0);
                newCHP.setHps(Math.max(newCHP.getHps() + increment, 8));
                break;
            }
            case 75: {
                newCHP.setHpsKern(param);
                break;
            }
            case 76: {
                StyleSheet.doCHPOperation(oldCHP, newCHP, 71, param, varParam, grpprl, offset, styleSheet);
                break;
            }
            case 77: {
                float percentage = (float)param / 100.0f;
                int add = (int)(percentage * (float)newCHP.getHps());
                newCHP.setHps(newCHP.getHps() + add);
                break;
            }
            case 78: {
                newCHP.setYsr((byte)param);
                break;
            }
            case 79: {
                newCHP.setFtcAscii((short)param);
                break;
            }
            case 80: {
                newCHP.setFtcFE((short)param);
                break;
            }
            case 81: {
                newCHP.setFtcOther((short)param);
                break;
            }
            case 82: {
                break;
            }
            case 83: {
                newCHP.setFDStrike(StyleSheet.getFlag(param));
                break;
            }
            case 84: {
                newCHP.setFImprint(StyleSheet.getFlag(param));
                break;
            }
            case 85: {
                newCHP.setFSpec(StyleSheet.getFlag(param));
                break;
            }
            case 86: {
                newCHP.setFObj(StyleSheet.getFlag(param));
                break;
            }
            case 87: {
                newCHP.setFPropMark(varParam[0]);
                newCHP.setIbstPropRMark(LittleEndian.getShort((byte[])varParam, (int)1));
                newCHP.setDttmPropRMark(LittleEndian.getInt((byte[])varParam, (int)3));
                break;
            }
            case 88: {
                newCHP.setFEmboss(StyleSheet.getFlag(param));
                break;
            }
            case 89: {
                newCHP.setSfxtText((byte)param);
                break;
            }
            case 90: {
                break;
            }
            case 91: {
                break;
            }
            case 92: {
                break;
            }
            case 93: {
                break;
            }
            case 94: {
                break;
            }
            case 95: {
                break;
            }
            case 96: {
                break;
            }
            case 97: {
                break;
            }
            case 98: {
                byte[] xstDispFldRMark = new byte[32];
                newCHP.setFDispFldRMark(varParam[0]);
                newCHP.setIbstDispFldRMark(LittleEndian.getShort((byte[])varParam, (int)1));
                newCHP.setDttmDispFldRMark(LittleEndian.getInt((byte[])varParam, (int)3));
                System.arraycopy(varParam, 7, xstDispFldRMark, 0, 32);
                newCHP.setXstDispFldRMark(xstDispFldRMark);
                break;
            }
            case 99: {
                newCHP.setIbstRMarkDel((short)param);
                break;
            }
            case 100: {
                short[] dttmRMarkDel = new short[]{LittleEndian.getShort((byte[])grpprl, (int)(offset - 4)), LittleEndian.getShort((byte[])grpprl, (int)(offset - 2))};
                newCHP.setDttmRMarkDel(dttmRMarkDel);
                break;
            }
            case 101: {
                short[] brc = new short[]{LittleEndian.getShort((byte[])grpprl, (int)(offset - 4)), LittleEndian.getShort((byte[])grpprl, (int)(offset - 2))};
                newCHP.setBrc(brc);
                break;
            }
            case 102: {
                newCHP.setShd((short)param);
                break;
            }
            case 103: {
                break;
            }
            case 104: {
                break;
            }
            case 105: {
                break;
            }
            case 106: {
                break;
            }
            case 107: {
                break;
            }
            case 108: {
                break;
            }
            case 109: {
                newCHP.setLidDefault((short)param);
                break;
            }
            case 110: {
                newCHP.setLidFE((short)param);
                break;
            }
            case 111: {
                newCHP.setIdctHint((byte)param);
            }
        }
    }

    public static Object uncompressProperty(byte[] grpprl, Object parent, StyleSheet styleSheet) {
        return StyleSheet.uncompressProperty(grpprl, parent, styleSheet, true);
    }

    public static Object uncompressProperty(byte[] grpprl, Object parent, StyleSheet styleSheet, boolean doIstd) {
        Object newProperty = null;
        int offset = 0;
        int propertyType = 1;
        if (parent instanceof ParagraphProperties) {
            try {
                newProperty = ((ParagraphProperties)parent).clone();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (doIstd) {
                ((ParagraphProperties)newProperty).setIstd(LittleEndian.getShort((byte[])grpprl, (int)0));
                offset = 2;
            }
        } else if (parent instanceof CharacterProperties) {
            try {
                newProperty = ((CharacterProperties)parent).clone();
                ((CharacterProperties)newProperty).setBaseIstd(((CharacterProperties)parent).getIstd());
            }
            catch (Exception e) {
                // empty catch block
            }
            propertyType = 2;
        } else if (parent instanceof SectionProperties) {
            newProperty = parent;
            propertyType = 4;
        } else if (parent instanceof TableProperties) {
            newProperty = parent;
            propertyType = 5;
            offset = 2;
        } else {
            return null;
        }
        while (offset < grpprl.length) {
            short sprm = LittleEndian.getShort((byte[])grpprl, (int)offset);
            offset += 2;
            byte spra = (byte)((sprm & 0xE000) >> 13);
            int opSize = 0;
            int param = 0;
            byte[] varParam = null;
            switch (spra) {
                case 0: 
                case 1: {
                    opSize = 1;
                    param = grpprl[offset];
                    break;
                }
                case 2: {
                    opSize = 2;
                    param = LittleEndian.getShort((byte[])grpprl, (int)offset);
                    break;
                }
                case 3: {
                    opSize = 4;
                    param = LittleEndian.getInt((byte[])grpprl, (int)offset);
                    break;
                }
                case 4: 
                case 5: {
                    opSize = 2;
                    param = LittleEndian.getShort((byte[])grpprl, (int)offset);
                    break;
                }
                case 6: {
                    if (sprm != -10744) {
                        opSize = LittleEndian.getUnsignedByte((byte[])grpprl, (int)offset);
                        ++offset;
                    } else {
                        opSize = LittleEndian.getShort((byte[])grpprl, (int)offset) - 1;
                        offset += 2;
                    }
                    varParam = new byte[opSize];
                    System.arraycopy(grpprl, offset, varParam, 0, opSize);
                    break;
                }
                case 7: {
                    opSize = 3;
                    byte[] threeByteInt = new byte[]{grpprl[offset], grpprl[offset + 1], grpprl[offset + 2], 0};
                    param = LittleEndian.getInt((byte[])threeByteInt, (int)0);
                    break;
                }
                default: {
                    throw new RuntimeException("unrecognized pap opcode");
                }
            }
            offset += opSize;
            short operand = (short)(sprm & 0x1FF);
            byte type = (byte)((sprm & 0x1C00) >> 10);
            switch (propertyType) {
                case 1: {
                    if (type != 1) break;
                    StyleSheet.doPAPOperation((ParagraphProperties)newProperty, operand, param, varParam, grpprl, offset, spra);
                    break;
                }
                case 2: {
                    StyleSheet.doCHPOperation((CharacterProperties)parent, (CharacterProperties)newProperty, operand, param, varParam, grpprl, offset, styleSheet);
                    break;
                }
                case 4: {
                    StyleSheet.doSEPOperation((SectionProperties)newProperty, operand, param, varParam);
                    break;
                }
                case 5: {
                    if (type != 5) break;
                    StyleSheet.doTAPOperation((TableProperties)newProperty, operand, param, varParam);
                }
            }
        }
        return newProperty;
    }

    static void doPAPOperation(ParagraphProperties newPAP, int operand, int param, byte[] varParam, byte[] grpprl, int offset, int spra) {
        switch (operand) {
            case 0: {
                newPAP.setIstd(param);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (newPAP.getIstd() > 9 && newPAP.getIstd() < 1) break;
                newPAP.setIstd(newPAP.getIstd() + param);
                if (param > 0) {
                    newPAP.setIstd(Math.max(newPAP.getIstd(), 9));
                    break;
                }
                newPAP.setIstd(Math.min(newPAP.getIstd(), 1));
                break;
            }
            case 3: {
                newPAP.setJc((byte)param);
                break;
            }
            case 4: {
                newPAP.setFSideBySide((byte)param);
                break;
            }
            case 5: {
                newPAP.setFKeep((byte)param);
                break;
            }
            case 6: {
                newPAP.setFKeepFollow((byte)param);
                break;
            }
            case 7: {
                newPAP.setFPageBreakBefore((byte)param);
                break;
            }
            case 8: {
                newPAP.setBrcl((byte)param);
                break;
            }
            case 9: {
                newPAP.setBrcp((byte)param);
                break;
            }
            case 10: {
                newPAP.setIlvl((byte)param);
                break;
            }
            case 11: {
                newPAP.setIlfo(param);
                break;
            }
            case 12: {
                newPAP.setFNoLnn((byte)param);
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                newPAP.setDxaRight(param);
                break;
            }
            case 15: {
                newPAP.setDxaLeft(param);
                break;
            }
            case 16: {
                newPAP.setDxaLeft(newPAP.getDxaLeft() + param);
                newPAP.setDxaLeft(Math.max(0, newPAP.getDxaLeft()));
                break;
            }
            case 17: {
                newPAP.setDxaLeft1(param);
                break;
            }
            case 18: {
                short[] lspd = newPAP.getLspd();
                lspd[0] = LittleEndian.getShort((byte[])grpprl, (int)(offset - 4));
                lspd[1] = LittleEndian.getShort((byte[])grpprl, (int)(offset - 2));
                break;
            }
            case 19: {
                newPAP.setDyaBefore(param);
                break;
            }
            case 20: {
                newPAP.setDyaAfter(param);
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                newPAP.setFInTable((byte)param);
                break;
            }
            case 23: {
                newPAP.setFTtp((byte)param);
                break;
            }
            case 24: {
                newPAP.setDxaAbs(param);
                break;
            }
            case 25: {
                newPAP.setDyaAbs(param);
                break;
            }
            case 26: {
                newPAP.setDxaWidth(param);
                break;
            }
            case 27: {
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                newPAP.setDxaFromText(param);
                break;
            }
            case 35: {
                newPAP.setWr((byte)param);
                break;
            }
            case 36: {
                short[] brcTop = newPAP.getBrcTop();
                brcTop[0] = LittleEndian.getShort((byte[])grpprl, (int)(offset - 4));
                brcTop[1] = LittleEndian.getShort((byte[])grpprl, (int)(offset - 2));
                break;
            }
            case 37: {
                short[] brcLeft = newPAP.getBrcLeft();
                brcLeft[0] = LittleEndian.getShort((byte[])grpprl, (int)(offset - 4));
                brcLeft[1] = LittleEndian.getShort((byte[])grpprl, (int)(offset - 2));
                break;
            }
            case 38: {
                short[] brcBottom = newPAP.getBrcBottom();
                brcBottom[0] = LittleEndian.getShort((byte[])grpprl, (int)(offset - 4));
                brcBottom[1] = LittleEndian.getShort((byte[])grpprl, (int)(offset - 2));
                break;
            }
            case 39: {
                short[] brcRight = newPAP.getBrcRight();
                brcRight[0] = LittleEndian.getShort((byte[])grpprl, (int)(offset - 4));
                brcRight[1] = LittleEndian.getShort((byte[])grpprl, (int)(offset - 2));
                break;
            }
            case 40: {
                short[] brcBetween = newPAP.getBrcBetween();
                brcBetween[0] = LittleEndian.getShort((byte[])grpprl, (int)(offset - 4));
                brcBetween[1] = LittleEndian.getShort((byte[])grpprl, (int)(offset - 2));
                break;
            }
            case 41: {
                short[] brcBar = newPAP.getBrcBar();
                brcBar[0] = LittleEndian.getShort((byte[])grpprl, (int)(offset - 4));
                brcBar[1] = LittleEndian.getShort((byte[])grpprl, (int)(offset - 2));
                break;
            }
            case 42: {
                newPAP.setFNoAutoHyph((byte)param);
                break;
            }
            case 43: {
                newPAP.setDyaHeight(param);
                break;
            }
            case 44: {
                newPAP.setDcs((short)param);
                break;
            }
            case 45: {
                newPAP.setShd((short)param);
                break;
            }
            case 46: {
                newPAP.setDyaFromText(param);
                break;
            }
            case 47: {
                newPAP.setDxaFromText(param);
                break;
            }
            case 48: {
                newPAP.setFLocked((byte)param);
                break;
            }
            case 49: {
                newPAP.setFWidowControl((byte)param);
                break;
            }
            case 50: {
                break;
            }
            case 51: {
                newPAP.setFKinsoku((byte)param);
                break;
            }
            case 52: {
                newPAP.setFWordWrap((byte)param);
                break;
            }
            case 53: {
                newPAP.setFOverflowPunct((byte)param);
                break;
            }
            case 54: {
                newPAP.setFTopLinePunct((byte)param);
                break;
            }
            case 55: {
                newPAP.setFAutoSpaceDE((byte)param);
                break;
            }
            case 56: {
                newPAP.setFAutoSpaceDN((byte)param);
                break;
            }
            case 57: {
                newPAP.setWAlignFont(param);
                break;
            }
            case 58: {
                newPAP.setFontAlign((short)param);
                break;
            }
            case 59: {
                break;
            }
            case 62: {
                newPAP.setAnld(varParam);
                break;
            }
            case 63: {
                break;
            }
            case 64: {
                break;
            }
            case 65: {
                break;
            }
            case 67: {
                break;
            }
            case 68: {
                break;
            }
            case 69: {
                if (spra != 6) break;
                newPAP.setNumrm(varParam);
                break;
            }
            case 71: {
                newPAP.setFUsePgsuSettings((byte)param);
                break;
            }
            case 72: {
                newPAP.setFAdjustRight((byte)param);
                break;
            }
        }
    }

    static void doTAPOperation(TableProperties newTAP, int operand, int param, byte[] varParam) {
        switch (operand) {
            case 0: {
                newTAP.setJc((short)param);
                break;
            }
            case 1: {
                short[] rgdxaCenter = newTAP.getRgdxaCenter();
                int itcMac = newTAP.getItcMac();
                int adjust = param - (rgdxaCenter[0] + newTAP.getDxaGapHalf());
                int x = 0;
                while (x < itcMac) {
                    int n = x++;
                    rgdxaCenter[n] = (short)(rgdxaCenter[n] + adjust);
                }
                break;
            }
            case 2: {
                short[] rgdxaCenter = newTAP.getRgdxaCenter();
                if (rgdxaCenter != null) {
                    int adjust = newTAP.getDxaGapHalf() - param;
                    rgdxaCenter[0] = (short)(rgdxaCenter[0] + adjust);
                }
                newTAP.setDxaGapHalf(param);
                break;
            }
            case 3: {
                newTAP.setFCantSplit(StyleSheet.getFlag(param));
                break;
            }
            case 4: {
                newTAP.setFTableHeader(StyleSheet.getFlag(param));
                break;
            }
            case 5: {
                short[] brcTop = newTAP.getBrcTop();
                short[] brcLeft = newTAP.getBrcLeft();
                short[] brcBottom = newTAP.getBrcBottom();
                short[] brcRight = newTAP.getBrcRight();
                short[] brcVertical = newTAP.getBrcVertical();
                short[] brcHorizontal = newTAP.getBrcHorizontal();
                brcTop[0] = LittleEndian.getShort((byte[])varParam, (int)0);
                brcTop[1] = LittleEndian.getShort((byte[])varParam, (int)2);
                brcLeft[0] = LittleEndian.getShort((byte[])varParam, (int)4);
                brcLeft[1] = LittleEndian.getShort((byte[])varParam, (int)6);
                brcBottom[0] = LittleEndian.getShort((byte[])varParam, (int)8);
                brcBottom[1] = LittleEndian.getShort((byte[])varParam, (int)10);
                brcRight[0] = LittleEndian.getShort((byte[])varParam, (int)12);
                brcRight[1] = LittleEndian.getShort((byte[])varParam, (int)14);
                brcHorizontal[0] = LittleEndian.getShort((byte[])varParam, (int)16);
                brcHorizontal[1] = LittleEndian.getShort((byte[])varParam, (int)18);
                brcVertical[0] = LittleEndian.getShort((byte[])varParam, (int)20);
                brcVertical[1] = LittleEndian.getShort((byte[])varParam, (int)22);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                newTAP.setDyaRowHeight(param);
                break;
            }
            case 8: {
                short[] rgdxaCenter = new short[varParam[0] + 1];
                TCAbstractType[] rgtc = new TableCellDescriptor[varParam[0]];
                int itcMac = varParam[0];
                newTAP.setItcMac((short)itcMac);
                newTAP.setRgdxaCenter(rgdxaCenter);
                newTAP.setRgtc(rgtc);
                for (int x = 0; x < itcMac; ++x) {
                    rgdxaCenter[x] = LittleEndian.getShort((byte[])varParam, (int)(1 + x * 2));
                    rgtc[x] = TableCellDescriptor.convertBytesToTC(varParam, 1 + (itcMac + 1) * 2 + x * 20);
                }
                rgdxaCenter[itcMac] = LittleEndian.getShort((byte[])varParam, (int)(1 + itcMac * 2));
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 32: {
                TCAbstractType[] rgtc = newTAP.getRgtc();
                for (int x = varParam[0]; x < varParam[1]; ++x) {
                    if ((varParam[2] & 8) > 0) {
                        short[] brcRight = rgtc[x].getBrcRight();
                        brcRight[0] = LittleEndian.getShort((byte[])varParam, (int)6);
                        brcRight[1] = LittleEndian.getShort((byte[])varParam, (int)8);
                        continue;
                    }
                    if ((varParam[2] & 4) > 0) {
                        short[] brcBottom = rgtc[x].getBrcBottom();
                        brcBottom[0] = LittleEndian.getShort((byte[])varParam, (int)6);
                        brcBottom[1] = LittleEndian.getShort((byte[])varParam, (int)8);
                        continue;
                    }
                    if ((varParam[2] & 2) > 0) {
                        short[] brcLeft = rgtc[x].getBrcLeft();
                        brcLeft[0] = LittleEndian.getShort((byte[])varParam, (int)6);
                        brcLeft[1] = LittleEndian.getShort((byte[])varParam, (int)8);
                        continue;
                    }
                    if ((varParam[2] & 1) <= 0) continue;
                    short[] brcTop = rgtc[x].getBrcTop();
                    brcTop[0] = LittleEndian.getShort((byte[])varParam, (int)6);
                    brcTop[1] = LittleEndian.getShort((byte[])varParam, (int)8);
                }
                break;
            }
            case 33: {
                int index = (param & 0xFF000000) >> 24;
                int count = (param & 0xFF0000) >> 16;
                int width = param & 0xFFFF;
                short itcMac = newTAP.getItcMac();
                short[] rgdxaCenter = new short[itcMac + count + 1];
                TableCellDescriptor[] rgtc = new TableCellDescriptor[itcMac + count];
                if (index >= itcMac) {
                    index = itcMac;
                    System.arraycopy(newTAP.getRgdxaCenter(), 0, rgdxaCenter, 0, itcMac + 1);
                    System.arraycopy(newTAP.getRgtc(), 0, rgtc, 0, itcMac);
                } else {
                    System.arraycopy(newTAP.getRgdxaCenter(), 0, rgdxaCenter, 0, index + 1);
                    System.arraycopy(newTAP.getRgdxaCenter(), index + 1, rgdxaCenter, index + count, itcMac - index);
                    System.arraycopy(newTAP.getRgtc(), 0, rgtc, 0, index);
                    System.arraycopy(newTAP.getRgtc(), index, rgtc, index + count, itcMac - index);
                }
                for (int x = index; x < index + count; ++x) {
                    rgtc[x] = new TableCellDescriptor();
                    rgdxaCenter[x] = (short)(rgdxaCenter[x - 1] + width);
                }
                rgdxaCenter[index + count] = (short)(rgdxaCenter[index + count - 1] + width);
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                break;
            }
        }
    }

    static void doSEPOperation(SectionProperties newSEP, int operand, int param, byte[] varParam) {
        switch (operand) {
            case 0: {
                newSEP.setCnsPgn((byte)param);
                break;
            }
            case 1: {
                newSEP.setIHeadingPgn((byte)param);
                break;
            }
            case 2: {
                newSEP.setOlstAnm(varParam);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                newSEP.setFEvenlySpaced(StyleSheet.getFlag(param));
                break;
            }
            case 6: {
                newSEP.setFUnlocked(StyleSheet.getFlag(param));
                break;
            }
            case 7: {
                newSEP.setDmBinFirst((short)param);
                break;
            }
            case 8: {
                newSEP.setDmBinOther((short)param);
                break;
            }
            case 9: {
                newSEP.setBkc((byte)param);
                break;
            }
            case 10: {
                newSEP.setFTitlePage(StyleSheet.getFlag(param));
                break;
            }
            case 11: {
                newSEP.setCcolM1((short)param);
                break;
            }
            case 12: {
                newSEP.setDxaColumns(param);
                break;
            }
            case 13: {
                newSEP.setFAutoPgn(StyleSheet.getFlag(param));
                break;
            }
            case 14: {
                newSEP.setNfcPgn((byte)param);
                break;
            }
            case 15: {
                newSEP.setDyaPgn((short)param);
                break;
            }
            case 16: {
                newSEP.setDxaPgn((short)param);
                break;
            }
            case 17: {
                newSEP.setFPgnRestart(StyleSheet.getFlag(param));
                break;
            }
            case 18: {
                newSEP.setFEndNote(StyleSheet.getFlag(param));
                break;
            }
            case 19: {
                newSEP.setLnc((byte)param);
                break;
            }
            case 20: {
                newSEP.setGrpfIhdt((byte)param);
                break;
            }
            case 21: {
                newSEP.setNLnnMod((short)param);
                break;
            }
            case 22: {
                newSEP.setDxaLnn(param);
                break;
            }
            case 23: {
                newSEP.setDyaHdrTop(param);
                break;
            }
            case 24: {
                newSEP.setDyaHdrBottom(param);
                break;
            }
            case 25: {
                newSEP.setFLBetween(StyleSheet.getFlag(param));
                break;
            }
            case 26: {
                newSEP.setVjc((byte)param);
                break;
            }
            case 27: {
                newSEP.setLnnMin((short)param);
                break;
            }
            case 28: {
                newSEP.setPgnStart((short)param);
                break;
            }
            case 29: {
                newSEP.setDmOrientPage((byte)param);
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                newSEP.setXaPage(param);
                break;
            }
            case 32: {
                newSEP.setYaPage(param);
                break;
            }
            case 33: {
                newSEP.setDxaLeft(param);
                break;
            }
            case 34: {
                newSEP.setDxaRight(param);
                break;
            }
            case 35: {
                newSEP.setDyaTop(param);
                break;
            }
            case 36: {
                newSEP.setDyaBottom(param);
                break;
            }
            case 37: {
                newSEP.setDzaGutter(param);
                break;
            }
            case 38: {
                newSEP.setDmPaperReq((short)param);
                break;
            }
            case 39: {
                newSEP.setFPropMark(StyleSheet.getFlag(varParam[0]));
                break;
            }
            case 40: {
                break;
            }
            case 41: {
                break;
            }
            case 42: {
                break;
            }
            case 43: {
                short[] brcTop = newSEP.getBrcTop();
                brcTop[0] = (short)(param & 0xFFFF);
                brcTop[1] = (short)((param & 0xFFFF0000) >> 16);
                break;
            }
            case 44: {
                short[] brcLeft = newSEP.getBrcLeft();
                brcLeft[0] = (short)(param & 0xFFFF);
                brcLeft[1] = (short)((param & 0xFFFF0000) >> 16);
                break;
            }
            case 45: {
                short[] brcBottom = newSEP.getBrcBottom();
                brcBottom[0] = (short)(param & 0xFFFF);
                brcBottom[1] = (short)((param & 0xFFFF0000) >> 16);
                break;
            }
            case 46: {
                short[] brcRight = newSEP.getBrcRight();
                brcRight[0] = (short)(param & 0xFFFF);
                brcRight[1] = (short)((param & 0xFFFF0000) >> 16);
                break;
            }
            case 47: {
                newSEP.setPgbProp(param);
                break;
            }
            case 48: {
                newSEP.setDxtCharSpace(param);
                break;
            }
            case 49: {
                newSEP.setDyaLinePitch(param);
                break;
            }
            case 51: {
                newSEP.setWTextFlow((short)param);
                break;
            }
        }
    }

    private static boolean getCHPFlag(byte x, boolean oldVal) {
        switch (x) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case -128: {
                return oldVal;
            }
            case -127: {
                return !oldVal;
            }
        }
        return false;
    }

    public static boolean getFlag(int x) {
        return x != 0;
    }
}

