/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler;

import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLFragment;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaErrorCondition;
import org.apache.vysper.xmpp.stanza.StanzaErrorType;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;

public class ErrorStanzaGenerator {
    protected static final String NOT_SUBSCRIBED = "not-subscribed";
    protected static final String SUBID_REQUIRED = "subid-required";
    protected static final String INVALID_SUBID = "invalid-subid";
    protected static final String INVALID_JID = "invalid-jid";

    public Stanza generateJIDMalformedErrorStanza(Entity sender, Entity receiver, IQStanza stanza) {
        return ServerErrorResponses.getStanzaError((StanzaErrorCondition)StanzaErrorCondition.JID_MALFORMED, (XMPPCoreStanza)stanza, (StanzaErrorType)StanzaErrorType.MODIFY, null, null, null);
    }

    public Stanza generateInsufficientPrivilegesErrorStanza(Entity sender, Entity receiver, IQStanza stanza) {
        return ServerErrorResponses.getStanzaError((StanzaErrorCondition)StanzaErrorCondition.FORBIDDEN, (XMPPCoreStanza)stanza, (StanzaErrorType)StanzaErrorType.AUTH, null, null, null);
    }

    public Stanza generateNoSuchSubscriberErrorStanza(Entity sender, Entity receiver, IQStanza stanza) {
        XMLElement notSubscribed = this.createXMLElement(NOT_SUBSCRIBED, "http://jabber.org/protocol/pubsub#errors");
        return ServerErrorResponses.getStanzaError((StanzaErrorCondition)StanzaErrorCondition.UNEXPECTED_REQUEST, (XMPPCoreStanza)stanza, (StanzaErrorType)StanzaErrorType.CANCEL, null, null, (XMLElement)notSubscribed);
    }

    public Stanza generateSubIDRequiredErrorStanza(Entity sender, Entity receiver, IQStanza stanza) {
        XMLElement subidRequired = this.createXMLElement(SUBID_REQUIRED, "http://jabber.org/protocol/pubsub#errors");
        return ServerErrorResponses.getStanzaError((StanzaErrorCondition)StanzaErrorCondition.BAD_REQUEST, (XMPPCoreStanza)stanza, (StanzaErrorType)StanzaErrorType.MODIFY, null, null, (XMLElement)subidRequired);
    }

    public Stanza generateNoNodeErrorStanza(Entity sender, Entity receiver, IQStanza stanza) {
        return ServerErrorResponses.getStanzaError((StanzaErrorCondition)StanzaErrorCondition.ITEM_NOT_FOUND, (XMPPCoreStanza)stanza, (StanzaErrorType)StanzaErrorType.CANCEL, null, null, null);
    }

    public Stanza generateSubIDNotValidErrorStanza(Entity sender, Entity receiver, IQStanza stanza) {
        XMLElement invalidSubID = this.createXMLElement(INVALID_SUBID, "http://jabber.org/protocol/pubsub#errors");
        return ServerErrorResponses.getStanzaError((StanzaErrorCondition)StanzaErrorCondition.NOT_ACCEPTABLE, (XMPPCoreStanza)stanza, (StanzaErrorType)StanzaErrorType.MODIFY, null, null, (XMLElement)invalidSubID);
    }

    public Stanza generateJIDDontMatchErrorStanza(Entity sender, Entity receiver, IQStanza stanza) {
        XMLElement invalidJID = this.createXMLElement(INVALID_JID, "http://jabber.org/protocol/pubsub#errors");
        return ServerErrorResponses.getStanzaError((StanzaErrorCondition)StanzaErrorCondition.BAD_REQUEST, (XMPPCoreStanza)stanza, (StanzaErrorType)StanzaErrorType.MODIFY, null, null, (XMLElement)invalidJID);
    }

    public Stanza generateBadRequestErrorStanza(Entity sender, Entity receiver, IQStanza stanza) {
        return ServerErrorResponses.getStanzaError((StanzaErrorCondition)StanzaErrorCondition.BAD_REQUEST, (XMPPCoreStanza)stanza, (StanzaErrorType)StanzaErrorType.MODIFY, null, null, null);
    }

    public Stanza generateDuplicateNodeErrorStanza(Entity sender, Entity receiver, IQStanza stanza) {
        return ServerErrorResponses.getStanzaError((StanzaErrorCondition)StanzaErrorCondition.CONFLICT, (XMPPCoreStanza)stanza, (StanzaErrorType)StanzaErrorType.CANCEL, null, null, null);
    }

    private XMLElement createXMLElement(String elementName, String namespace) {
        XMLElement element = new XMLElement(namespace, elementName, null, null, (XMLFragment[])null);
        return element;
    }

    public Stanza generateNotAcceptableErrorStanza(Entity sender, Entity receiver, IQStanza stanza) {
        return ServerErrorResponses.getStanzaError((StanzaErrorCondition)StanzaErrorCondition.NOT_ACCEPTABLE, (XMPPCoreStanza)stanza, (StanzaErrorType)StanzaErrorType.MODIFY, null, null, null);
    }
}

