/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.openpgp;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Objects;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.ECSecretBCPGKey;
import org.bouncycastle.bcpg.EdSecretBCPGKey;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.c02e.jpgpj.Subkey;

@FunctionalInterface
public interface PGPPrivateKeyExtractor {
    default public PrivateKey extractPrivateKey(NamedResource resourceKey, Subkey sk, PublicKey pubKey) throws IOException, GeneralSecurityException, PGPException {
        if (sk == null) {
            return null;
        }
        PGPPrivateKey pgpKey = Objects.requireNonNull(sk.getPrivateKey(), "Missing sub-key private key");
        BCPGKey bcKey = Objects.requireNonNull(pgpKey.getPrivateKeyDataPacket(), "Missing BC key");
        if (bcKey instanceof RSASecretBCPGKey) {
            return this.extractRSAPrivateKey(resourceKey, (RSAPublicKey)pubKey, (RSASecretBCPGKey)bcKey);
        }
        if (bcKey instanceof ECSecretBCPGKey) {
            return this.extractECDSAPrivateKey(resourceKey, (ECPublicKey)pubKey, (ECSecretBCPGKey)bcKey);
        }
        if (bcKey instanceof EdSecretBCPGKey) {
            return this.extractEdDSAPrivateKey(resourceKey, pubKey, (EdSecretBCPGKey)bcKey);
        }
        if (bcKey instanceof DSASecretBCPGKey) {
            return this.extractDSSPrivateKey(resourceKey, (DSAPublicKey)pubKey, (DSASecretBCPGKey)bcKey);
        }
        throw new NoSuchAlgorithmException("Unsupported BC public key type: " + bcKey.getClass().getSimpleName());
    }

    default public ECPrivateKey extractECDSAPrivateKey(NamedResource resourceKey, ECPublicKey pubKey, ECSecretBCPGKey bcKey) throws IOException, GeneralSecurityException {
        if (bcKey == null) {
            return null;
        }
        ECParameterSpec params = pubKey.getParams();
        BigInteger x = bcKey.getX();
        return this.generatePrivateKey("EC", ECPrivateKey.class, new ECPrivateKeySpec(x, params));
    }

    default public PrivateKey extractEdDSAPrivateKey(NamedResource resourceKey, PublicKey pubKey, EdSecretBCPGKey bcKey) throws IOException, GeneralSecurityException {
        if (bcKey == null) {
            return null;
        }
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchProviderException("EdDSA not supported");
        }
        throw new NoSuchAlgorithmException("Unsupported EdDSA private key type: " + bcKey.getClass().getSimpleName());
    }

    default public RSAPrivateKey extractRSAPrivateKey(NamedResource resourceKey, RSAPublicKey pubKey, RSASecretBCPGKey bcKey) throws IOException, GeneralSecurityException {
        if (bcKey == null) {
            return null;
        }
        return this.generatePrivateKey("RSA", RSAPrivateKey.class, new RSAPrivateCrtKeySpec(bcKey.getModulus(), pubKey.getPublicExponent(), bcKey.getPrivateExponent(), bcKey.getPrimeP(), bcKey.getPrimeQ(), bcKey.getPrimeExponentP(), bcKey.getPrimeExponentQ(), bcKey.getCrtCoefficient()));
    }

    default public DSAPrivateKey extractDSSPrivateKey(NamedResource resourceKey, DSAPublicKey pubKey, DSASecretBCPGKey bcKey) throws IOException, GeneralSecurityException {
        if (bcKey == null) {
            return null;
        }
        DSAParams params = pubKey.getParams();
        if (params == null) {
            throw new InvalidKeyException("Missing parameters in public key");
        }
        return this.generatePrivateKey("DSA", DSAPrivateKey.class, new DSAPrivateKeySpec(bcKey.getX(), params.getP(), params.getQ(), params.getG()));
    }

    public <K extends PrivateKey> K generatePrivateKey(String var1, Class<K> var2, KeySpec var3) throws GeneralSecurityException;
}

