/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.mina;

import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.transport.socket.nio.NioSession;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.mina.MinaService;

public class MinaConnector
extends MinaService
implements IoConnector,
org.apache.mina.core.service.IoHandler {
    protected final AtomicReference<org.apache.mina.core.service.IoConnector> connectorHolder = new AtomicReference<Object>(null);

    public MinaConnector(FactoryManager manager, IoHandler handler, IoProcessor<NioSession> ioProcessor) {
        super(manager, handler, ioProcessor);
    }

    protected org.apache.mina.core.service.IoConnector createConnector() {
        NioSocketConnector connector = new NioSocketConnector(this.ioProcessor);
        this.configure(connector.getSessionConfig());
        return connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected org.apache.mina.core.service.IoConnector getConnector() {
        org.apache.mina.core.service.IoConnector connector;
        AtomicReference<org.apache.mina.core.service.IoConnector> atomicReference = this.connectorHolder;
        synchronized (atomicReference) {
            connector = this.connectorHolder.get();
            if (connector != null) {
                return connector;
            }
            connector = this.createConnector();
            connector.setHandler((org.apache.mina.core.service.IoHandler)this);
            this.connectorHolder.set(connector);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created IoConnector: {}", (Object)connector);
        }
        return connector;
    }

    @Override
    protected IoService getIoService() {
        return this.getConnector();
    }

    public void sessionCreated(org.apache.mina.core.session.IoSession session) throws Exception {
        IoServiceEventListener listener = this.getIoServiceEventListener();
        SocketAddress local = session.getLocalAddress();
        SocketAddress remote = session.getRemoteAddress();
        AttributeRepository context = (AttributeRepository)session.getAttribute(AttributeRepository.class);
        try {
            if (listener != null) {
                try {
                    listener.connectionEstablished((IoConnector)this, local, context, remote);
                }
                catch (Exception e) {
                    session.closeNow();
                    throw e;
                }
            }
            this.sessionCreated(session, null);
        }
        catch (Exception e) {
            if (listener != null) {
                try {
                    listener.abortEstablishedConnection((IoConnector)this, local, context, remote, (Throwable)e);
                }
                catch (Exception exc) {
                    this.debug("sessionCreated({}) ignoring abort connection failure={}: {}", session, exc.getClass().getSimpleName(), exc.getMessage(), exc);
                }
            }
            throw e;
        }
    }

    public IoConnectFuture connect(final SocketAddress address, final AttributeRepository context, SocketAddress localAddress) {
        class Future
        extends DefaultSshFuture<IoConnectFuture>
        implements IoConnectFuture {
            Future(Object lock) {
                super((Object)socketAddress, lock);
            }

            public IoSession getSession() {
                Object v = this.getValue();
                return v instanceof IoSession ? (IoSession)v : null;
            }

            public Throwable getException() {
                Object v = this.getValue();
                return v instanceof Throwable ? (Throwable)v : null;
            }

            public boolean isConnected() {
                return this.getValue() instanceof IoSession;
            }

            public void setSession(IoSession session) {
                if (context != null) {
                    session.setAttribute(AttributeRepository.class, (Object)context);
                }
                this.setValue(session);
            }

            public void setException(Throwable exception) {
                this.setValue(exception);
            }
        }
        Future future = new Future(null);
        org.apache.mina.core.service.IoConnector connector = this.getConnector();
        ConnectFuture connectFuture = connector.connect(address, localAddress, (s, f) -> {
            if (context != null) {
                s.setAttribute(AttributeRepository.class, (Object)context);
            }
        });
        connectFuture.addListener(cf -> {
            Throwable t = cf.getException();
            if (t != null) {
                future.setException(t);
            } else if (cf.isCanceled()) {
                future.cancel();
            } else {
                org.apache.mina.core.session.IoSession ioSession = cf.getSession();
                IoSession sshSession = this.getSession(ioSession);
                if (context != null) {
                    sshSession.setAttribute(AttributeRepository.class, (Object)context);
                }
                future.setSession(sshSession);
            }
        });
        return future;
    }
}

