/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

def buildLog = new File( basedir, 'build.log' ); 
assert buildLog.exists()

// 2 = parent + child
assert 2 == buildLog.text.count( '  Profile Id: it-repo (Active: true, Source: settings.xml)' )
assert 2 == buildLog.text.count( '  Profile Id: profile-active-from-parent-pom (Active: true, Source: pom)' ) 
assert 2 == buildLog.text.count( '  Profile Id: profile-inactive-from-parent-pom (Active: false, Source: pom)' )
assert 1 == buildLog.text.count( '  Profile Id: profile-active-from-child-pom (Active: true, Source: pom)' ) 
assert 1 == buildLog.text.count( '  Profile Id: profile-inactive-from-child-pom (Active: false, Source: pom)' )
