/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.utils.filters;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.plugin.dependency.utils.filters.ArtifactItemFilter;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.codehaus.plexus.util.StringUtils;

public class DestFileFilter
extends AbstractArtifactsFilter
implements ArtifactItemFilter {
    boolean overWriteReleases;
    boolean overWriteSnapshots;
    boolean overWriteIfNewer;
    boolean useSubDirectoryPerArtifact;
    boolean useSubDirectoryPerType;
    boolean useRepositoryLayout;
    boolean removeVersion;
    File outputFileDirectory;

    public DestFileFilter(File outputFileDirectory) {
        this.outputFileDirectory = outputFileDirectory;
        this.overWriteReleases = false;
        this.overWriteIfNewer = false;
        this.overWriteSnapshots = false;
        this.useSubDirectoryPerArtifact = false;
        this.useSubDirectoryPerType = false;
        this.removeVersion = false;
    }

    public DestFileFilter(boolean overWriteReleases, boolean overWriteSnapshots, boolean overWriteIfNewer, boolean useSubDirectoryPerArtifact, boolean useSubDirectoryPerType, boolean useRepositoryLayout, boolean removeVersion, File outputFileDirectory) {
        this.overWriteReleases = overWriteReleases;
        this.overWriteSnapshots = overWriteSnapshots;
        this.overWriteIfNewer = overWriteIfNewer;
        this.useSubDirectoryPerArtifact = useSubDirectoryPerArtifact;
        this.useSubDirectoryPerType = useSubDirectoryPerType;
        this.useRepositoryLayout = useRepositoryLayout;
        this.removeVersion = removeVersion;
        this.outputFileDirectory = outputFileDirectory;
    }

    public Set filter(Set artifacts) throws ArtifactFilterException {
        HashSet<Artifact> result = new HashSet<Artifact>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (!this.isArtifactIncluded(new ArtifactItem(artifact))) continue;
            result.add(artifact);
        }
        return result;
    }

    public boolean isOverWriteReleases() {
        return this.overWriteReleases;
    }

    public void setOverWriteReleases(boolean overWriteReleases) {
        this.overWriteReleases = overWriteReleases;
    }

    public boolean isOverWriteSnapshots() {
        return this.overWriteSnapshots;
    }

    public void setOverWriteSnapshots(boolean overWriteSnapshots) {
        this.overWriteSnapshots = overWriteSnapshots;
    }

    public boolean isOverWriteIfNewer() {
        return this.overWriteIfNewer;
    }

    public void setOverWriteIfNewer(boolean overWriteIfNewer) {
        this.overWriteIfNewer = overWriteIfNewer;
    }

    public File getOutputFileDirectory() {
        return this.outputFileDirectory;
    }

    public void setOutputFileDirectory(File outputFileDirectory) {
        this.outputFileDirectory = outputFileDirectory;
    }

    public boolean isRemoveVersion() {
        return this.removeVersion;
    }

    public void setRemoveVersion(boolean removeVersion) {
        this.removeVersion = removeVersion;
    }

    public boolean isUseSubDirectoryPerArtifact() {
        return this.useSubDirectoryPerArtifact;
    }

    public void setUseSubDirectoryPerArtifact(boolean useSubDirectoryPerArtifact) {
        this.useSubDirectoryPerArtifact = useSubDirectoryPerArtifact;
    }

    public boolean isUseSubDirectoryPerType() {
        return this.useSubDirectoryPerType;
    }

    public void setUseSubDirectoryPerType(boolean useSubDirectoryPerType) {
        this.useSubDirectoryPerType = useSubDirectoryPerType;
    }

    public boolean isUseRepositoryLayout() {
        return this.useRepositoryLayout;
    }

    public void setUseRepositoryLayout(boolean useRepositoryLayout) {
        this.useRepositoryLayout = useRepositoryLayout;
    }

    public boolean isArtifactIncluded(ArtifactItem item) {
        File destFolder;
        boolean overWrite = false;
        boolean result = false;
        Artifact artifact = item.getArtifact();
        if (artifact.isSnapshot() && this.overWriteSnapshots || !artifact.isSnapshot() && this.overWriteReleases) {
            overWrite = true;
        }
        if ((destFolder = item.getOutputDirectory()) == null) {
            destFolder = DependencyUtil.getFormattedOutputDirectory(this.useSubDirectoryPerType, this.useSubDirectoryPerArtifact, this.useRepositoryLayout, this.removeVersion, this.outputFileDirectory, artifact);
        }
        File destFile = null;
        destFile = StringUtils.isEmpty((String)item.getDestFileName()) ? new File(destFolder, DependencyUtil.getFormattedFileName(artifact, this.removeVersion)) : new File(destFolder, item.getDestFileName());
        if (overWrite || !destFile.exists() || this.overWriteIfNewer && artifact.getFile().lastModified() > destFile.lastModified()) {
            result = true;
        }
        return result;
    }
}

