/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.marshaller;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.client.MediaType;
import org.nuxeo.client.MediaTypes;
import org.nuxeo.client.Responses;
import org.nuxeo.client.objects.blob.Blobs;
import org.nuxeo.client.objects.blob.FileBlob;
import org.nuxeo.client.spi.NuxeoClientException;
import org.nuxeo.client.util.IOUtils;
import retrofit2.Converter;

public final class NuxeoResponseConverterFactory<T>
implements Converter<ResponseBody, T> {
    protected final JavaType javaType;
    protected final ObjectMapper objectMapper;
    protected final Map<String, Class<?>> entityTypeToClass;

    protected NuxeoResponseConverterFactory(ObjectMapper objectMapper, JavaType javaType, Map<String, Class<?>> entityTypeToClass) {
        this.objectMapper = objectMapper;
        this.javaType = javaType;
        this.entityTypeToClass = entityTypeToClass;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T convert(ResponseBody body) throws IOException {
        MediaType mediaType = MediaType.fromOkHttpMediaType(body.contentType());
        if (!MediaTypes.APPLICATION_JSON.equalsTypeSubType(mediaType) && !MediaTypes.APPLICATION_JSON_NXENTITY.equalsTypeSubType(mediaType)) {
            if (!mediaType.type().equals("multipart")) {
                File tmpFile = IOUtils.copyToTempFile(body.byteStream());
                return (T)new FileBlob(tmpFile);
            }
            ArrayList<FileBlob> blobs = new ArrayList<FileBlob>();
            try (InputStream is = body.byteStream();){
                MimeMultipart mp = new MimeMultipart((DataSource)new ByteArrayDataSource(is, mediaType.toString()));
                int size = mp.getCount();
                int i = 0;
                while (i < size) {
                    BodyPart part = mp.getBodyPart(i);
                    blobs.add(new FileBlob(IOUtils.copyToTempFile(part.getInputStream()), part.getFileName(), part.getContentType()));
                    ++i;
                }
                return (T)new Blobs(blobs);
            }
            catch (MessagingException reason) {
                throw new IOException(reason);
            }
        }
        if (this.javaType.getRawClass().equals(Object.class)) {
            Class<?> entityClass;
            String entityType = mediaType.nuxeoEntity();
            String bodyString = Responses.bodyToString(body);
            body.close();
            if (entityType == null) {
                entityType = bodyString.replaceFirst(".*\"entity-type\":\"([^\"]*)\".*", "$1");
                entityType = StringUtils.trimToNull((String)entityType);
            }
            if ((entityClass = this.entityTypeToClass.get(entityType)) != null) return (T)this.readJSON(bodyString, entityClass);
            return (T)bodyString;
        }
        try (Reader reader = body.charStream();){
            ObjectReader objectReader = this.objectMapper.readerFor(this.javaType);
            Object object = objectReader.readValue(reader);
            return (T)object;
        }
        catch (IOException reason) {
            throw new NuxeoClientException("Error during deserialization of HTTP body", reason);
        }
    }

    public <U> U readJSON(String value, Class<U> javaType) {
        try {
            return (U)this.objectMapper.readValue(value, javaType);
        }
        catch (IOException reason) {
            throw new NuxeoClientException("Converter Read Issue.", reason);
        }
    }
}

