/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.engine.SQLTypeInfos;
import org.exolab.castor.jdo.engine.JDOClassDescriptor;
import org.exolab.castor.jdo.engine.JDOFieldDescriptor;
import org.exolab.castor.jdo.engine.SQLQuery;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.persist.spi.Identity;

public final class SQLHelper {
    private static final Log LOG = LogFactory.getLog((Class)SQLQuery.class);

    public static Object[] calculateNumberOfFields(Collection extendingClassDescriptors, int numberOfIdentityColumns, int numberOfFields, int numberOfExtendLevels, ResultSet rs) throws SQLException {
        int initialColumnIndex;
        ClassDescriptorImpl potentialLeafDescriptor = null;
        int suggestedNumberOfFields = numberOfFields;
        LinkedList potentialActualClassDescriptor = new LinkedList();
        int numberOfIdentitiesToAnalyze = 0;
        SQLHelper.addExtendingClassDescriptors(potentialActualClassDescriptor, extendingClassDescriptors);
        JDOClassDescriptor potentialClassDescriptor = null;
        JDOClassDescriptor potentialClassDescriptorPrevious = null;
        int columnIndex = initialColumnIndex = numberOfFields + numberOfIdentityColumns * numberOfExtendLevels + 1;
        int numberOfExtendingClassDescriptors = 0;
        Iterator iter = potentialActualClassDescriptor.iterator();
        while (iter.hasNext()) {
            JDOFieldDescriptor jdoFieldDescriptor;
            potentialClassDescriptor = (JDOClassDescriptor)iter.next();
            ++numberOfExtendingClassDescriptors;
            LOG.debug((Object)("Potential extending class descriptor: " + potentialClassDescriptor.getJavaClass().getName()));
            FieldDescriptor[] identityDescriptors = potentialClassDescriptor.getIdentities();
            boolean isNull = true;
            for (int i = 0; i < identityDescriptors.length; ++i) {
                Object temp;
                jdoFieldDescriptor = (JDOFieldDescriptor)identityDescriptors[i];
                if (jdoFieldDescriptor.getSQLName().length == 1) {
                    temp = SQLTypeInfos.getValue(rs, columnIndex++, 2000);
                } else {
                    Object[] temps = new Object[jdoFieldDescriptor.getSQLName().length];
                    for (int j = 0; j < jdoFieldDescriptor.getSQLName().length; ++j) {
                        temps[j] = SQLTypeInfos.getValue(rs, columnIndex++, 2000);
                    }
                    temp = new Identity(temps);
                }
                LOG.debug((Object)("Obtained value " + temp + " for additional (extending) identity " + potentialClassDescriptor.getJavaClass().getName() + "/" + identityDescriptors[i].getFieldName() + " at position " + columnIndex));
                boolean bl = isNull = temp == null;
                if (isNull) continue;
                ++numberOfIdentitiesToAnalyze;
                potentialClassDescriptorPrevious = potentialClassDescriptor;
            }
            if (!iter.hasNext() && !isNull && numberOfIdentitiesToAnalyze > 0) {
                potentialLeafDescriptor = potentialClassDescriptor;
                suggestedNumberOfFields += potentialClassDescriptor.getFields().length;
                continue;
            }
            if (!iter.hasNext() && isNull && numberOfIdentitiesToAnalyze > 0) {
                potentialLeafDescriptor = potentialClassDescriptorPrevious;
                continue;
            }
            FieldDescriptor[] potentialFields = potentialClassDescriptor.getFields();
            for (int i = 0; i < potentialFields.length; ++i) {
                jdoFieldDescriptor = (JDOFieldDescriptor)potentialFields[i];
                String[] columnNames = jdoFieldDescriptor.getSQLName();
                columnIndex += columnNames.length;
            }
            if (isNull) continue;
            suggestedNumberOfFields += potentialClassDescriptor.getFields().length;
        }
        LOG.debug((Object)("In total " + numberOfIdentitiesToAnalyze + " (extending) identities analyzed."));
        if (potentialLeafDescriptor != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Most likely of type " + potentialLeafDescriptor.getJavaClass().getName()));
            LOG.debug((Object)("After analysis, " + suggestedNumberOfFields + " fields need to be loaded."));
        }
        return new Object[]{potentialLeafDescriptor, new Integer(suggestedNumberOfFields)};
    }

    public static int numberOfExtendingClassDescriptors(JDOClassDescriptor classDescriptor) {
        int numberOfExtendLevels = 1;
        JDOClassDescriptor currentClassDescriptor = classDescriptor;
        while (currentClassDescriptor.getExtends() != null) {
            currentClassDescriptor = (JDOClassDescriptor)currentClassDescriptor.getExtends();
            ++numberOfExtendLevels;
        }
        return numberOfExtendLevels;
    }

    public static void addExtendingClassDescriptors(Collection classDescriptorsToAdd, Collection extendingClassDescriptors) {
        JDOClassDescriptor classDescriptor = null;
        Iterator iter = extendingClassDescriptors.iterator();
        while (iter.hasNext()) {
            classDescriptor = (JDOClassDescriptor)iter.next();
            classDescriptorsToAdd.add(classDescriptor);
            SQLHelper.addExtendingClassDescriptors(classDescriptorsToAdd, classDescriptor.getExtendedBy());
        }
    }

    private SQLHelper() {
    }
}

