/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.jdo.drivers.JDBCQueryExpression;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class SapDbQueryExpression
extends JDBCQueryExpression {
    public SapDbQueryExpression(PersistenceFactory factory) {
        super(factory);
    }

    public String getStatement(boolean lock) {
        JDBCQueryExpression.Join join;
        Vector<Object> sorted = new Vector<Object>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        if (this._distinct) {
            sql.append(" DISTINCT ");
        }
        sql.append(this.getColumnList());
        sql.append(" FROM ");
        Enumeration<Object> enumeration = this._joins.elements();
        while (enumeration.hasMoreElements()) {
            join = (JDBCQueryExpression.Join)enumeration.nextElement();
            if (!join.outer) continue;
            int left = sorted.indexOf(join.leftTable);
            int right = sorted.indexOf(join.rightTable);
            if (left >= 0 && right >= 0) {
                if (left <= right) continue;
                sorted.removeElement(join.leftTable);
                sorted.insertElementAt(join.leftTable, right);
                continue;
            }
            if (left < 0 && right >= 0) {
                sorted.insertElementAt(join.leftTable, right);
                continue;
            }
            if (left >= 0 && right < 0) {
                sorted.insertElementAt(join.rightTable, left + 1);
                continue;
            }
            sorted.addElement(join.leftTable);
            sorted.addElement(join.rightTable);
        }
        enumeration = this._tables.keys();
        while (enumeration.hasMoreElements()) {
            Object name = enumeration.nextElement();
            if (sorted.contains(name)) continue;
            sorted.addElement(name);
        }
        enumeration = sorted.elements();
        while (enumeration.hasMoreElements()) {
            String tableName;
            String tableAlias = (String)enumeration.nextElement();
            if (tableAlias.equals(tableName = (String)this._tables.get(tableAlias))) {
                sql.append(this._factory.quoteName(tableName));
            } else {
                sql.append(this._factory.quoteName(tableName) + " " + this._factory.quoteName(tableAlias));
            }
            if (!enumeration.hasMoreElements()) continue;
            sql.append(",");
        }
        boolean first = true;
        int size = this._joins.size();
        for (int i = 0; i < size; ++i) {
            if (first) {
                sql.append(" WHERE ");
                first = false;
            } else {
                sql.append(" AND ");
            }
            join = (JDBCQueryExpression.Join)this._joins.elementAt(i);
            for (int j = 0; j < join.leftColumns.length; ++j) {
                if (j > 0) {
                    sql.append(" AND ");
                }
                sql.append(this._factory.quoteName(join.leftTable + "." + join.leftColumns[j]));
                sql.append("=");
                sql.append(this._factory.quoteName(join.rightTable + "." + join.rightColumns[j]));
                if (!join.outer) continue;
                sql.append("(+)");
            }
        }
        first = this.addWhereClause(sql, first);
        if (this._order != null) {
            sql.append(" ORDER BY ").append(this._order);
        }
        if (lock) {
            sql.append(" WITH LOCK");
        }
        return sql.toString();
    }
}

