/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.changelog;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.svn.SvnChangeSet;
import org.apache.maven.scm.provider.svn.svnexe.command.changelog.IllegalOutputException;
import org.apache.maven.scm.util.AbstractConsumer;
import org.apache.regexp.RE;

public class SvnChangeLogConsumer
extends AbstractConsumer {
    private static final String SVN_TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss zzzzzzzzz";
    private static final int GET_HEADER = 1;
    private static final int GET_FILE = 2;
    private static final int GET_COMMENT = 3;
    private static final String FILE_BEGIN_TOKEN = " ";
    private static final String FILE_END_TOKEN = "";
    private static final int FILE_START_INDEX = 5;
    private static final String COMMENT_END_TOKEN = "------------------------------------------------------------------------";
    private int status = 1;
    private List entries = new ArrayList();
    private SvnChangeSet currentChange;
    private String currentRevision;
    private StringBuffer currentComment;
    private static final RE HEADER_REG_EXP = new RE("^(.+) \\| (.+) \\| (.+) \\|.*$");
    private static final int REVISION_GROUP = 1;
    private static final int AUTHOR_GROUP = 2;
    private static final int DATE_GROUP = 3;
    private static final RE REVISION_REG_EXP1 = new RE("rev (\\d+):");
    private static final RE REVISION_REG_EXP2 = new RE("r(\\d+)");
    private static final RE DATE_REG_EXP = new RE("(\\d+-\\d+-\\d+ \\d+:\\d+:\\d+) ([\\-+])(\\d\\d)(\\d\\d)");
    private final String userDateFormat;

    public SvnChangeLogConsumer(ScmLogger logger, String userDateFormat) {
        super(logger);
        this.userDateFormat = userDateFormat;
    }

    public List getModifications() {
        return this.entries;
    }

    public void consumeLine(String line) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(line);
        }
        switch (this.status) {
            case 1: {
                this.processGetHeader(line);
                break;
            }
            case 2: {
                this.processGetFile(line);
                break;
            }
            case 3: {
                this.processGetComment(line);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + this.status);
            }
        }
    }

    private void processGetHeader(String line) {
        if (!HEADER_REG_EXP.match(line)) {
            return;
        }
        this.currentRevision = this.getRevision(HEADER_REG_EXP.getParen(1));
        this.currentChange = new SvnChangeSet();
        this.currentChange.setAuthor(HEADER_REG_EXP.getParen(2));
        this.currentChange.setDate(this.getDate(HEADER_REG_EXP.getParen(3)));
        this.currentChange.setRevision(this.currentRevision);
        this.status = 2;
    }

    private String getRevision(String revisionOutput) {
        if (REVISION_REG_EXP1.match(revisionOutput)) {
            return REVISION_REG_EXP1.getParen(1);
        }
        if (REVISION_REG_EXP2.match(revisionOutput)) {
            return REVISION_REG_EXP2.getParen(1);
        }
        throw new IllegalOutputException(revisionOutput);
    }

    private void processGetFile(String line) {
        if (line.startsWith(FILE_BEGIN_TOKEN)) {
            String name = line.substring(5);
            this.currentChange.addFile(new ChangeFile(name, this.currentRevision));
            this.status = 2;
        } else if (line.equals(FILE_END_TOKEN)) {
            this.currentComment = new StringBuffer();
            this.status = 3;
        }
    }

    private void processGetComment(String line) {
        if (line.equals(COMMENT_END_TOKEN)) {
            this.currentChange.setComment(this.currentComment.toString());
            this.entries.add(this.currentChange);
            this.status = 1;
        } else {
            this.currentComment.append(line).append('\n');
        }
    }

    private Date getDate(String dateOutput) {
        if (!DATE_REG_EXP.match(dateOutput)) {
            throw new IllegalOutputException(dateOutput);
        }
        StringBuffer date = new StringBuffer();
        date.append(DATE_REG_EXP.getParen(1));
        date.append(" GMT");
        date.append(DATE_REG_EXP.getParen(2));
        date.append(DATE_REG_EXP.getParen(3));
        date.append(':');
        date.append(DATE_REG_EXP.getParen(4));
        return this.parseDate(date.toString(), this.userDateFormat, SVN_TIMESTAMP_PATTERN);
    }
}

