/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.nio.DoubleBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.measure.Quantity;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.image.BandSelectImage;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.Interpolation;
import org.apache.sis.image.RecoloredImage;
import org.apache.sis.image.ResampledImage;
import org.apache.sis.image.Transferer;
import org.apache.sis.internal.coverage.CompoundTransform;
import org.apache.sis.internal.coverage.j2d.Colorizer;
import org.apache.sis.internal.coverage.j2d.ImageLayout;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.math.Statistics;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class Visualization
extends ResampledImage {
    private final MathTransform1D[] converters;
    private final ColorModel colorModel;

    Visualization(RenderedImage renderedImage, ImageLayout imageLayout, Rectangle rectangle, MathTransform mathTransform, boolean bl, Interpolation interpolation, MathTransform1D[] mathTransform1DArray, Number[] numberArray, ColorModel colorModel, Quantity<?>[] quantityArray) {
        super(renderedImage, imageLayout.createBandedSampleModel(0, mathTransform1DArray.length, renderedImage, rectangle), imageLayout.getMinTile(), rectangle != null ? rectangle : ImageUtilities.getBounds(renderedImage), mathTransform, bl ? Interpolation.NEAREST : Visualization.combine(interpolation, mathTransform1DArray), numberArray, quantityArray);
        this.colorModel = colorModel;
        this.converters = bl ? mathTransform1DArray : null;
    }

    static Interpolation combine(Interpolation interpolation, MathTransform1D[] mathTransform1DArray) {
        MathTransform mathTransform = CompoundTransform.create((MathTransform[])mathTransform1DArray);
        if (mathTransform.isIdentity()) {
            return interpolation;
        }
        if (mathTransform instanceof MathTransform1D) {
            return new InterpConvertOneBand(interpolation, (MathTransform1D)mathTransform);
        }
        return new InterpConvert(interpolation, mathTransform);
    }

    @Override
    final boolean hasNoMask() {
        return !(this.interpolation instanceof InterpConvert) && super.hasNoMask();
    }

    static RenderedImage create(ImageProcessor imageProcessor, Rectangle rectangle, RenderedImage renderedImage, MathTransform mathTransform, List<SampleDimension> list, Collection<Map.Entry<NumberRange<?>, Color[]>> collection) throws NoninvertibleTransformException {
        int n;
        boolean bl;
        Colorizer colorizer;
        int n2 = ImageUtilities.getVisibleBand(renderedImage);
        if (n2 < 0) {
            throw new IllegalArgumentException(Resources.format((short)55));
        }
        if (collection != null) {
            colorizer = new Colorizer(collection);
            bl = true;
        } else {
            colorizer = new Colorizer(imageProcessor.getCategoryColors());
            boolean bl2 = bl = list != null && colorizer.initialize(list.get(n2));
            if (bl) {
                colorizer.rescaleMainRange(renderedImage.getColorModel());
            } else {
                bl = colorizer.initialize(renderedImage.getColorModel()) || colorizer.initialize(renderedImage.getSampleModel(), n2);
            }
        }
        renderedImage = BandSelectImage.create(renderedImage, new int[]{n2});
        if (!bl) {
            Statistics statistics = imageProcessor.valueOfStatistics(renderedImage, null)[0];
            colorizer.initialize(statistics.minimum(), statistics.maximum());
        }
        if ((n = renderedImage.getSampleModel().getDataType()) == 0 || n == 1) {
            if (mathTransform != null && !mathTransform.isIdentity()) {
                renderedImage = imageProcessor.resample(renderedImage, rectangle, mathTransform);
            }
            return RecoloredImage.create(renderedImage, colorizer.createColorModel(n, 1, 0));
        }
        while (renderedImage instanceof RecoloredImage) {
            renderedImage = ((RecoloredImage)renderedImage).source;
        }
        if (mathTransform == null) {
            mathTransform = MathTransforms.identity((int)2);
        }
        ColorModel colorModel = colorizer.compactColorModel(1, 0);
        MathTransform1D mathTransform1D = colorizer.getSampleToIndexValues();
        return imageProcessor.resampleAndConvert(renderedImage, mathTransform, new MathTransform1D[]{mathTransform1D}, rectangle, colorModel);
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    protected Raster computeTile(int n, int n2, WritableRaster writableRaster) throws TransformException {
        if (this.converters == null) {
            try {
                return super.computeTile(n, n2, writableRaster);
            }
            catch (BackingStoreException backingStoreException) {
                throw backingStoreException.unwrapOrRethrow(TransformException.class);
            }
        }
        if (writableRaster == null) {
            writableRaster = this.createTile(n, n2);
        }
        Transferer.create(this.getSource(), writableRaster).compute(this.converters);
        return writableRaster;
    }

    private static final class InterpConvertOneBand
    extends InterpConvert {
        private final MathTransform1D singleConverter;

        InterpConvertOneBand(Interpolation interpolation, MathTransform1D mathTransform1D) {
            super(interpolation, (MathTransform)mathTransform1D);
            this.singleConverter = mathTransform1D;
        }

        @Override
        public void interpolate(DoubleBuffer doubleBuffer, int n, double d, double d2, double[] dArray, int n2) {
            this.interpolation.interpolate(doubleBuffer, n, d, d2, dArray, n2);
            try {
                dArray[n2] = this.singleConverter.transform(dArray[n2]);
            }
            catch (TransformException transformException) {
                throw new BackingStoreException(transformException);
            }
        }
    }

    static class InterpConvert
    implements Interpolation {
        final Interpolation interpolation;
        final MathTransform converter;

        InterpConvert(Interpolation interpolation, MathTransform mathTransform) {
            this.interpolation = interpolation;
            this.converter = mathTransform;
        }

        @Override
        public final Dimension getSupportSize() {
            return this.interpolation.getSupportSize();
        }

        @Override
        public void interpolate(DoubleBuffer doubleBuffer, int n, double d, double d2, double[] dArray, int n2) {
            this.interpolation.interpolate(doubleBuffer, n, d, d2, dArray, n2);
            try {
                this.converter.transform(dArray, n2, dArray, n2, 1);
            }
            catch (TransformException transformException) {
                throw new BackingStoreException(transformException);
            }
        }
    }
}

