/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.hibernate;

import java.net.URL;
import java.util.Properties;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.NonstopConfiguration;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.config.TimeoutBehaviorConfiguration;
import org.hibernate.cache.CacheException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HibernateUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HibernateUtil.class);

    private HibernateUtil() {
    }

    static Configuration loadAndCorrectConfiguration(URL url) {
        Configuration config = ConfigurationFactory.parseConfiguration(url);
        if (config.getDefaultCacheConfiguration() != null && config.getDefaultCacheConfiguration().isTerracottaClustered()) {
            if (TerracottaConfiguration.ValueMode.IDENTITY.equals((Object)config.getDefaultCacheConfiguration().getTerracottaConfiguration().getValueMode())) {
                LOG.warn("The default cache value mode for this Ehcache configuration is \"identity\". This is incompatible with clustered Hibernate caching - the value mode has therefore been switched to \"serialization\"");
                config.getDefaultCacheConfiguration().getTerracottaConfiguration().setValueMode(TerracottaConfiguration.ValueMode.SERIALIZATION.name());
            }
            HibernateUtil.setupHibernateTimeoutBehavior(config.getDefaultCacheConfiguration().getTerracottaConfiguration().getNonstopConfiguration());
        }
        for (CacheConfiguration cacheConfig : config.getCacheConfigurations().values()) {
            if (!cacheConfig.isTerracottaClustered()) continue;
            if (TerracottaConfiguration.ValueMode.IDENTITY.equals((Object)cacheConfig.getTerracottaConfiguration().getValueMode())) {
                LOG.warn("The value mode for the {0} cache is \"identity\". This is incompatible with clustered Hibernate caching - the value mode has therefore been switched to \"serialization\"", (Object)cacheConfig.getName());
                cacheConfig.getTerracottaConfiguration().setValueMode(TerracottaConfiguration.ValueMode.SERIALIZATION.name());
            }
            HibernateUtil.setupHibernateTimeoutBehavior(cacheConfig.getTerracottaConfiguration().getNonstopConfiguration());
        }
        return config;
    }

    private static void setupHibernateTimeoutBehavior(NonstopConfiguration nonstopConfig) {
        nonstopConfig.getTimeoutBehavior().setType(TimeoutBehaviorConfiguration.TimeoutBehaviorType.EXCEPTION.getTypeName());
    }

    static void validateEhcache(Ehcache cache) throws CacheException {
        CacheConfiguration cacheConfig = cache.getCacheConfiguration();
        if (cacheConfig.isTerracottaClustered()) {
            TerracottaConfiguration tcConfig = cacheConfig.getTerracottaConfiguration();
            switch (tcConfig.getValueMode()) {
                case IDENTITY: {
                    throw new CacheException("The clustered Hibernate cache " + cache.getName() + " is using IDENTITY value mode.\n" + "Identity value mode cannot be used with Hibernate cache regions.");
                }
            }
        }
    }

    static Configuration overwriteCacheManagerIfConfigured(Configuration configuration, Properties properties) {
        String cacheManagerName = properties.getProperty("net.sf.ehcache.cacheManagerName");
        if (cacheManagerName != null) {
            configuration.setName(cacheManagerName);
        }
        return configuration;
    }
}

