/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.api.SecondaryType;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.SessionImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.ExtensionLevel;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;
import org.apache.chemistry.opencmis.commons.spi.Holder;

public abstract class AbstractCmisObject
implements CmisObject,
Serializable {
    private static final long serialVersionUID = 1L;
    private SessionImpl session;
    private ObjectType objectType;
    private List<SecondaryType> secondaryTypes;
    private Map<String, Property<?>> properties;
    private AllowableActions allowableActions;
    private List<Rendition> renditions;
    private Acl acl;
    private List<String> policyIds;
    private List<Policy> policies;
    private List<Relationship> relationships;
    private Map<ExtensionLevel, List<CmisExtensionElement>> extensions;
    private OperationContext creationContext;
    private long refreshTimestamp;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    protected void initialize(SessionImpl session, ObjectType objectType, ObjectData objectData, OperationContext context) {
        if (session == null) {
            throw new IllegalArgumentException("Session must be set!");
        }
        if (objectType == null) {
            throw new IllegalArgumentException("Object type must be set!");
        }
        if (objectType.getPropertyDefinitions() == null || objectType.getPropertyDefinitions().size() < 9) {
            throw new IllegalArgumentException("Object type must have property definitions!");
        }
        if (objectData == null) {
            throw new IllegalArgumentException("Object data must be set!");
        }
        if (objectData.getProperties() == null) {
            throw new IllegalArgumentException("Properties must be set!");
        }
        if (objectData.getId() == null) {
            throw new IllegalArgumentException("Object ID must be set!");
        }
        this.session = session;
        this.objectType = objectType;
        this.secondaryTypes = null;
        this.extensions = new EnumMap<ExtensionLevel, List<CmisExtensionElement>>(ExtensionLevel.class);
        this.creationContext = new OperationContextImpl(context);
        this.refreshTimestamp = System.currentTimeMillis();
        ObjectFactory of = this.getObjectFactory();
        if (objectData.getProperties().getProperties() != null && objectData.getProperties().getProperties().containsKey("cmis:secondaryObjectTypeIds")) {
            List stids = ((PropertyData)objectData.getProperties().getProperties().get("cmis:secondaryObjectTypeIds")).getValues();
            if (CollectionsHelper.isNotEmpty((Collection)stids)) {
                this.secondaryTypes = new ArrayList<SecondaryType>(stids.size());
                Iterator iterator = stids.iterator();
                while (iterator.hasNext()) {
                    ObjectType type;
                    String stid = (String)iterator.next();
                    if (stid == null || !((type = session.getTypeDefinition(stid)) instanceof SecondaryType)) continue;
                    this.secondaryTypes.add((SecondaryType)type);
                }
            } else {
                this.secondaryTypes = null;
            }
        }
        this.properties = of.convertProperties(objectType, this.secondaryTypes, objectData.getProperties());
        this.extensions.put(ExtensionLevel.PROPERTIES, objectData.getProperties().getExtensions());
        if (objectData.getAllowableActions() != null) {
            this.allowableActions = objectData.getAllowableActions();
            this.extensions.put(ExtensionLevel.ALLOWABLE_ACTIONS, objectData.getAllowableActions().getExtensions());
        } else {
            this.allowableActions = null;
        }
        if (objectData.getRenditions() != null && !objectData.getRenditions().isEmpty()) {
            this.renditions = new ArrayList<Rendition>(objectData.getRenditions().size());
            for (RenditionData rd : objectData.getRenditions()) {
                this.renditions.add(of.convertRendition(this.getId(), rd));
            }
        } else {
            this.renditions = null;
        }
        if (objectData.getAcl() != null) {
            this.acl = objectData.getAcl();
            this.extensions.put(ExtensionLevel.ACL, objectData.getAcl().getExtensions());
            if (objectData.isExactAcl() != null) {
                final Acl objectAcl = objectData.getAcl();
                final Boolean isExact = objectData.isExactAcl();
                this.acl = new Acl(){

                    public void setExtensions(List<CmisExtensionElement> extensions) {
                        objectAcl.setExtensions(extensions);
                    }

                    public List<CmisExtensionElement> getExtensions() {
                        return objectAcl.getExtensions();
                    }

                    public Boolean isExact() {
                        return isExact;
                    }

                    public List<Ace> getAces() {
                        return objectAcl.getAces();
                    }
                };
            }
        } else {
            this.acl = null;
        }
        this.policies = null;
        if (objectData.getPolicyIds() != null && objectData.getPolicyIds().getPolicyIds() != null) {
            this.policyIds = objectData.getPolicyIds().getPolicyIds().isEmpty() ? null : objectData.getPolicyIds().getPolicyIds();
            this.extensions.put(ExtensionLevel.POLICIES, objectData.getPolicyIds().getExtensions());
        } else {
            this.policyIds = null;
        }
        if (objectData.getRelationships() != null && !objectData.getRelationships().isEmpty()) {
            this.relationships = new ArrayList<Relationship>(objectData.getRelationships().size());
            for (ObjectData rod : objectData.getRelationships()) {
                CmisObject relationship = of.convertObject(rod, this.creationContext);
                if (!(relationship instanceof Relationship)) continue;
                this.relationships.add((Relationship)relationship);
            }
        } else {
            this.relationships = null;
        }
        this.extensions.put(ExtensionLevel.OBJECT, objectData.getExtensions());
    }

    protected void writeLock() {
        this.lock.writeLock().lock();
    }

    protected void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    protected void readLock() {
        this.lock.readLock().lock();
    }

    protected void readUnlock() {
        this.lock.readLock().unlock();
    }

    protected SessionImpl getSession() {
        return this.session;
    }

    protected String getRepositoryId() {
        return this.getSession().getRepositoryId();
    }

    protected ObjectType getObjectType() {
        this.readLock();
        try {
            ObjectType objectType = this.objectType;
            return objectType;
        }
        finally {
            this.readUnlock();
        }
    }

    protected CmisBinding getBinding() {
        return this.getSession().getBinding();
    }

    protected ObjectFactory getObjectFactory() {
        return this.getSession().getObjectFactory();
    }

    protected String getObjectId() {
        String objectId = this.getId();
        if (objectId == null) {
            throw new IllegalStateException("Object Id is unknown!");
        }
        return objectId;
    }

    protected OperationContext getCreationContext() {
        return this.creationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPropertyQueryName(String propertyId) {
        this.readLock();
        try {
            PropertyDefinition propDef = (PropertyDefinition)this.objectType.getPropertyDefinitions().get(propertyId);
            if (propDef == null) {
                String string = null;
                return string;
            }
            String string = propDef.getQueryName();
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    public void delete() {
        this.delete(true);
    }

    public void delete(boolean allVersions) {
        this.readLock();
        try {
            this.getSession().delete((ObjectId)this, allVersions);
        }
        finally {
            this.readUnlock();
        }
    }

    public CmisObject updateProperties(Map<String, ?> properties) {
        ObjectId objectId = this.updateProperties(properties, true);
        if (objectId == null) {
            return null;
        }
        if (!this.getObjectId().equals(objectId.getId())) {
            return this.getSession().getObject(objectId, this.getCreationContext());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId updateProperties(Map<String, ?> properties, boolean refresh) {
        if (CollectionsHelper.isNullOrEmpty(properties)) {
            throw new IllegalArgumentException("Properties must not be empty!");
        }
        this.readLock();
        String newObjectId = null;
        try {
            String objectId = this.getObjectId();
            Holder objectIdHolder = new Holder((Object)objectId);
            String changeToken = this.getChangeToken();
            Holder changeTokenHolder = new Holder((Object)changeToken);
            EnumSet<Updatability> updatebility = EnumSet.noneOf(Updatability.class);
            updatebility.add(Updatability.READWRITE);
            Boolean isCheckedOut = (Boolean)this.getPropertyValue("cmis:isVersionSeriesCheckedOut");
            if (Boolean.TRUE.equals(isCheckedOut)) {
                updatebility.add(Updatability.WHENCHECKEDOUT);
            }
            this.getBinding().getObjectService().updateProperties(this.getRepositoryId(), objectIdHolder, changeTokenHolder, this.getObjectFactory().convertProperties(properties, this.objectType, this.secondaryTypes, updatebility), null);
            newObjectId = (String)objectIdHolder.getValue();
            this.getSession().removeObjectFromCache(objectId);
        }
        finally {
            this.readUnlock();
        }
        if (refresh) {
            this.refresh();
        }
        if (newObjectId == null) {
            return null;
        }
        return this.getSession().createObjectId(newObjectId);
    }

    public CmisObject updateProperties(Map<String, ?> properties, List<String> addSecondaryTypeIds, List<String> removeSecondaryTypeIds) {
        ObjectId objectId = this.updateProperties(properties, addSecondaryTypeIds, removeSecondaryTypeIds, true);
        if (objectId == null) {
            return null;
        }
        if (!this.getObjectId().equals(objectId.getId())) {
            return this.getSession().getObject(objectId, this.getCreationContext());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId updateProperties(Map<String, ?> properties, List<String> addSecondaryTypeIds, List<String> removeSecondaryTypeIds, boolean refresh) {
        if ((addSecondaryTypeIds == null || addSecondaryTypeIds.isEmpty()) && (removeSecondaryTypeIds == null || removeSecondaryTypeIds.isEmpty())) {
            return this.updateProperties(properties, refresh);
        }
        ArrayList<String> secondaryTypeIds = new ArrayList<String>();
        this.readLock();
        try {
            if (!this.properties.containsKey("cmis:secondaryObjectTypeIds")) {
                throw new IllegalStateException("Secondary Object Type Ids are not available!");
            }
            if (this.secondaryTypes != null) {
                for (SecondaryType type : this.secondaryTypes) {
                    if (removeSecondaryTypeIds != null && removeSecondaryTypeIds.contains(type.getId())) continue;
                    secondaryTypeIds.add(type.getId());
                }
            }
            if (addSecondaryTypeIds != null) {
                for (String addId : addSecondaryTypeIds) {
                    if (secondaryTypeIds.contains(addId)) continue;
                    secondaryTypeIds.add(addId);
                }
            }
        }
        finally {
            this.readUnlock();
        }
        HashMap<String, Object> newProperties = new HashMap<String, Object>();
        if (properties != null) {
            newProperties.putAll(properties);
        }
        newProperties.put("cmis:secondaryObjectTypeIds", secondaryTypeIds);
        return this.updateProperties(newProperties, refresh);
    }

    public CmisObject rename(String newName) {
        if (newName == null || newName.length() == 0) {
            throw new IllegalArgumentException("New name must not be empty!");
        }
        HashMap<String, String> prop = new HashMap<String, String>(2);
        prop.put("cmis:name", newName);
        return this.updateProperties(prop);
    }

    public ObjectId rename(String newName, boolean refresh) {
        if (newName == null || newName.length() == 0) {
            throw new IllegalArgumentException("New name must not be empty!");
        }
        HashMap<String, String> prop = new HashMap<String, String>(2);
        prop.put("cmis:name", newName);
        return this.updateProperties(prop, refresh);
    }

    public ObjectType getBaseType() {
        BaseTypeId baseTypeId = this.getBaseTypeId();
        if (baseTypeId == null) {
            return null;
        }
        return this.getSession().getTypeDefinition(baseTypeId.value());
    }

    public BaseTypeId getBaseTypeId() {
        String baseType = (String)this.getPropertyValue("cmis:baseTypeId");
        if (baseType == null) {
            return null;
        }
        return BaseTypeId.fromValue((String)baseType);
    }

    public String getChangeToken() {
        return (String)this.getPropertyValue("cmis:changeToken");
    }

    public String getCreatedBy() {
        return (String)this.getPropertyValue("cmis:createdBy");
    }

    public GregorianCalendar getCreationDate() {
        return (GregorianCalendar)this.getPropertyValue("cmis:creationDate");
    }

    public String getId() {
        return (String)this.getPropertyValue("cmis:objectId");
    }

    public GregorianCalendar getLastModificationDate() {
        return (GregorianCalendar)this.getPropertyValue("cmis:lastModificationDate");
    }

    public String getLastModifiedBy() {
        return (String)this.getPropertyValue("cmis:lastModifiedBy");
    }

    public String getName() {
        return (String)this.getPropertyValue("cmis:name");
    }

    public String getDescription() {
        return (String)this.getPropertyValue("cmis:description");
    }

    public List<Property<?>> getProperties() {
        this.readLock();
        try {
            List<Property<?>> list = Collections.unmodifiableList(new ArrayList(this.properties.values()));
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    public <T> Property<T> getProperty(String id) {
        this.readLock();
        try {
            Property<?> property = this.properties.get(id);
            return property;
        }
        finally {
            this.readUnlock();
        }
    }

    public <T> T getPropertyValue(String id) {
        Property<T> property = this.getProperty(id);
        if (property == null) {
            return null;
        }
        return (T)property.getValue();
    }

    public ObjectType getType() {
        this.readLock();
        try {
            ObjectType objectType = this.objectType;
            return objectType;
        }
        finally {
            this.readUnlock();
        }
    }

    public List<SecondaryType> getSecondaryTypes() {
        this.readLock();
        try {
            List<SecondaryType> list = this.secondaryTypes;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ObjectType> findObjectType(String id) {
        ArrayList<Object> result = null;
        this.readLock();
        try {
            if (this.objectType.getPropertyDefinitions().containsKey(id)) {
                result = new ArrayList<ObjectType>();
                result.add(this.objectType);
            }
            if (this.secondaryTypes != null) {
                for (SecondaryType secondaryType : this.secondaryTypes) {
                    if (secondaryType.getPropertyDefinitions() == null || !secondaryType.getPropertyDefinitions().containsKey(id)) continue;
                    if (result == null) {
                        result = new ArrayList();
                    }
                    result.add((ObjectType)secondaryType);
                }
            }
        }
        finally {
            this.readUnlock();
        }
        return result;
    }

    public AllowableActions getAllowableActions() {
        this.readLock();
        try {
            AllowableActions allowableActions = this.allowableActions;
            return allowableActions;
        }
        finally {
            this.readUnlock();
        }
    }

    public boolean hasAllowableAction(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Action must be set!");
        }
        AllowableActions currentAllowableActions = this.getAllowableActions();
        if (currentAllowableActions == null || currentAllowableActions.getAllowableActions() == null) {
            throw new IllegalStateException("Allowable Actions are not available!");
        }
        return currentAllowableActions.getAllowableActions().contains(action);
    }

    public List<Rendition> getRenditions() {
        this.readLock();
        try {
            List<Rendition> list = this.renditions;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    public Acl getAcl(boolean onlyBasicPermissions) {
        String objectId = this.getObjectId();
        return this.getBinding().getAclService().getAcl(this.getRepositoryId(), objectId, Boolean.valueOf(onlyBasicPermissions), null);
    }

    public Acl applyAcl(List<Ace> addAces, List<Ace> removeAces, AclPropagation aclPropagation) {
        Acl result = this.getSession().applyAcl((ObjectId)this, addAces, removeAces, aclPropagation);
        this.refresh();
        return result;
    }

    public Acl addAcl(List<Ace> addAces, AclPropagation aclPropagation) {
        return this.applyAcl(addAces, null, aclPropagation);
    }

    public Acl removeAcl(List<Ace> removeAces, AclPropagation aclPropagation) {
        return this.applyAcl(null, removeAces, aclPropagation);
    }

    public Acl setAcl(List<Ace> aces) {
        Acl result = this.getSession().setAcl((ObjectId)this, aces);
        this.refresh();
        return result;
    }

    public Acl getAcl() {
        this.readLock();
        try {
            Acl acl = this.acl;
            return acl;
        }
        finally {
            this.readUnlock();
        }
    }

    public Set<String> getPermissionsForPrincipal(String principalId) {
        if (principalId == null) {
            throw new IllegalArgumentException("Principal must be set!");
        }
        Acl currentAcl = this.getAcl();
        if (currentAcl == null) {
            throw new IllegalStateException("ACLs are not available!");
        }
        if (CollectionsHelper.isNullOrEmpty((Collection)this.acl.getAces())) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (Ace ace : this.acl.getAces()) {
            if (!principalId.equals(ace.getPrincipalId()) || ace.getPermissions() == null) continue;
            result.addAll(ace.getPermissions());
        }
        return result;
    }

    public void applyPolicy(ObjectId ... policyIds) {
        this.readLock();
        try {
            this.getSession().applyPolicy((ObjectId)this, policyIds);
        }
        finally {
            this.readUnlock();
        }
        this.refresh();
    }

    public void applyPolicy(ObjectId policyId, boolean refresh) {
        this.readLock();
        try {
            this.getSession().applyPolicy((ObjectId)this, policyId);
        }
        finally {
            this.readUnlock();
        }
        if (refresh) {
            this.refresh();
        }
    }

    public void removePolicy(ObjectId ... policyIds) {
        this.readLock();
        try {
            this.getSession().removePolicy((ObjectId)this, policyIds);
        }
        finally {
            this.readUnlock();
        }
        this.refresh();
    }

    public void removePolicy(ObjectId policyId, boolean refresh) {
        this.readLock();
        try {
            this.getSession().removePolicy((ObjectId)this, policyId);
        }
        finally {
            this.readUnlock();
        }
        if (refresh) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Policy> getPolicies() {
        this.readLock();
        try {
            if (this.policies != null || this.policyIds == null) {
                List<Policy> list = this.policies;
                return list;
            }
        }
        finally {
            this.readUnlock();
        }
        this.writeLock();
        try {
            if (this.policies == null) {
                this.policies = new ArrayList<Policy>(this.policyIds.size());
                for (String pid : this.policyIds) {
                    try {
                        CmisObject policy = this.session.getObject(pid);
                        if (!(policy instanceof Policy)) continue;
                        this.policies.add((Policy)policy);
                    }
                    catch (CmisObjectNotFoundException cmisObjectNotFoundException) {}
                }
            }
            List<Policy> list = this.policies;
            return list;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ObjectId> getPolicyIds() {
        this.readLock();
        try {
            if (this.policyIds == null) {
                List<ObjectId> list = null;
                return list;
            }
            ArrayList<ObjectId> result = new ArrayList<ObjectId>(this.policyIds.size());
            for (String pid : this.policyIds) {
                result.add(this.session.createObjectId(pid));
            }
            ArrayList<ObjectId> arrayList = result;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    public List<Relationship> getRelationships() {
        this.readLock();
        try {
            List<Relationship> list = this.relationships;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    public List<CmisExtensionElement> getExtensions(ExtensionLevel level) {
        List<CmisExtensionElement> ext = this.extensions.get(level);
        if (ext == null) {
            return null;
        }
        return Collections.unmodifiableList(ext);
    }

    public <T> T getAdapter(Class<T> adapterInterface) {
        return null;
    }

    public long getRefreshTimestamp() {
        this.readLock();
        try {
            long l = this.refreshTimestamp;
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.writeLock();
        try {
            String objectId = this.getObjectId();
            OperationContext oc = this.getCreationContext();
            ObjectData objectData = this.getSession().getBinding().getObjectService().getObject(this.getRepositoryId(), objectId, oc.getFilterString(), Boolean.valueOf(oc.isIncludeAllowableActions()), oc.getIncludeRelationships(), oc.getRenditionFilterString(), Boolean.valueOf(oc.isIncludePolicies()), Boolean.valueOf(oc.isIncludeAcls()), null);
            this.initialize(this.session, this.session.getTypeDefinition(this.objectType.getId()), objectData, this.creationContext);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void refreshIfOld(long durationInMillis) {
        this.writeLock();
        try {
            if (this.refreshTimestamp < System.currentTimeMillis() - durationInMillis) {
                this.refresh();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public String toString() {
        this.readLock();
        try {
            if (this.objectType == null) {
                String string = "<unknown>";
                return string;
            }
            String string = this.objectType.getBaseTypeId() + " (" + this.objectType.getId() + "): " + this.getId();
            return string;
        }
        finally {
            this.readUnlock();
        }
    }
}

