/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.jts;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sis.internal.system.DelayedExecutor;
import org.apache.sis.internal.system.DelayedRunnable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBWriter;

final class FilteringContext {
    private static final Queue<WKBWriter> WRITERS = new ConcurrentLinkedQueue<WKBWriter>();
    private static final AtomicBoolean CLEANER_REGISTERED = new AtomicBoolean();

    private FilteringContext() {
    }

    static byte[] writeWKB(Geometry geometry) {
        WKBWriter wKBWriter = WRITERS.poll();
        if (wKBWriter == null) {
            wKBWriter = new WKBWriter();
        }
        byte[] byArray = wKBWriter.write(geometry);
        if (WRITERS.add(wKBWriter) && CLEANER_REGISTERED.compareAndSet(false, true)) {
            DelayedExecutor.schedule(new DelayedRunnable(2, TimeUnit.MINUTES){

                @Override
                public void run() {
                    CLEANER_REGISTERED.set(false);
                    WRITERS.clear();
                }
            });
        }
        return byArray;
    }
}

