/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.IPList;
import org.apache.hadoop.util.MachineList;

public class FileBasedIPList
implements IPList {
    private static final Log LOG = LogFactory.getLog(FileBasedIPList.class);
    private final String fileName;
    private final MachineList addressList;

    public FileBasedIPList(String fileName) {
        this.fileName = fileName;
        String[] lines = FileBasedIPList.readLines(fileName);
        this.addressList = lines != null ? new MachineList(new HashSet<String>(Arrays.asList(lines))) : null;
    }

    public FileBasedIPList reload() {
        return new FileBasedIPList(this.fileName);
    }

    @Override
    public boolean isIn(String ipAddress) {
        if (ipAddress == null || this.addressList == null) {
            return false;
        }
        return this.addressList.includes(ipAddress);
    }

    private static String[] readLines(String fileName) {
        try {
            if (fileName != null) {
                File file = new File(fileName);
                if (file.exists()) {
                    FileReader fileReader = new FileReader(file);
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    ArrayList<String> lines = new ArrayList<String>();
                    String line = null;
                    while ((line = bufferedReader.readLine()) != null) {
                        lines.add(line);
                    }
                    bufferedReader.close();
                    LOG.debug((Object)("Loaded IP list of size = " + lines.size() + " from file = " + fileName));
                    return lines.toArray(new String[lines.size()]);
                }
                LOG.debug((Object)("Missing ip list file : " + fileName));
            }
        }
        catch (Throwable t) {
            LOG.error((Object)t);
        }
        return null;
    }
}

