/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.lockmanager;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.lockmanager.ZooKeeperConnectionPool;
import org.apache.manifoldcf.core.lockmanager.ZooKeeperEphemeralNodeObject;

public class ZooKeeperEphemeralNodePool {
    protected final ZooKeeperConnectionPool pool;
    protected final Map<String, ZooKeeperEphemeralNodeObject> nodes = new HashMap<String, ZooKeeperEphemeralNodeObject>();

    public ZooKeeperEphemeralNodePool(ZooKeeperConnectionPool pool) {
        this.pool = pool;
    }

    public void createNode(String nodePath, byte[] nodeData) throws ManifoldCFException, InterruptedException {
        this.getObject(nodePath).createNode(nodeData);
    }

    public void setNodeData(String nodePath, byte[] nodeData) throws ManifoldCFException, InterruptedException {
        this.getObject(nodePath).setNodeData(nodeData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(String nodePath) throws ManifoldCFException, InterruptedException {
        ZooKeeperEphemeralNodePool zooKeeperEphemeralNodePool = this;
        synchronized (zooKeeperEphemeralNodePool) {
            ZooKeeperEphemeralNodeObject rval = this.nodes.get(nodePath);
            if (rval != null) {
                rval.deleteNode();
                this.nodes.remove(nodePath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() throws ManifoldCFException, InterruptedException {
        ZooKeeperEphemeralNodePool zooKeeperEphemeralNodePool = this;
        synchronized (zooKeeperEphemeralNodePool) {
            while (this.nodes.size() > 0) {
                Iterator<String> nodePathIter = this.nodes.keySet().iterator();
                String nodePath = nodePathIter.next();
                this.deleteNode(nodePath);
            }
        }
    }

    protected synchronized ZooKeeperEphemeralNodeObject getObject(String nodePath) {
        ZooKeeperEphemeralNodeObject rval = this.nodes.get(nodePath);
        if (rval != null) {
            return rval;
        }
        rval = new ZooKeeperEphemeralNodeObject(nodePath, this.pool);
        this.nodes.put(nodePath, rval);
        return rval;
    }
}

