/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.converter;

import java.io.Serializable;
import org.apache.sis.util.ObjectConverter;

class ClassPair<S, T>
implements Serializable {
    private static final long serialVersionUID = -5214470401299470687L;
    final Class<S> sourceClass;
    final Class<T> targetClass;

    ClassPair(Class<S> clazz, Class<T> clazz2) {
        this.sourceClass = clazz;
        this.targetClass = clazz2;
    }

    final ClassPair<? super S, T> parentSource() {
        Class<Object> clazz;
        if (this.sourceClass.isInterface()) {
            Class<?>[] classArray = this.sourceClass.getInterfaces();
            if (classArray.length == 0) {
                return null;
            }
            clazz = classArray[0];
        } else {
            clazz = this.sourceClass.getSuperclass();
            if (clazz == null) {
                return null;
            }
        }
        return new ClassPair<S, T>(clazz, this.targetClass);
    }

    final ObjectConverter<? super S, ? extends T> cast(ObjectConverter<?, ?> objectConverter) {
        if (objectConverter != null) {
            assert (objectConverter.getSourceClass().isAssignableFrom(this.sourceClass)) : this.sourceClass;
            assert (this.targetClass.isAssignableFrom(objectConverter.getTargetClass())) : this.targetClass;
        }
        return objectConverter;
    }

    public boolean equals(Object object) {
        if (object instanceof ClassPair) {
            ClassPair classPair = (ClassPair)object;
            return this.sourceClass == classPair.sourceClass && this.targetClass == classPair.targetClass;
        }
        return false;
    }

    public final int hashCode() {
        return this.sourceClass.hashCode() + 31 * this.targetClass.hashCode();
    }

    public String toString() {
        return this.targetClass.getSimpleName() + "\u00a0\u2190\u00a0" + this.sourceClass.getSimpleName();
    }
}

