/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.sis.referencing.operation.transform.MolodenskyTransform;
import org.apache.sis.referencing.operation.transform.MolodenskyTransform2D;
import org.opengis.referencing.datum.Ellipsoid;

final class AbridgedMolodenskyTransform2D
extends MolodenskyTransform2D {
    private static final long serialVersionUID = -7732503837408555590L;
    private transient double scale;

    AbridgedMolodenskyTransform2D(Ellipsoid ellipsoid, Ellipsoid ellipsoid2) {
        super(ellipsoid, ellipsoid2, 0.0, 0.0, 0.0, true);
        this.computeTransientFields();
    }

    AbridgedMolodenskyTransform2D(MolodenskyTransform molodenskyTransform, Ellipsoid ellipsoid, Ellipsoid ellipsoid2) {
        super(molodenskyTransform, ellipsoid, ellipsoid2);
        this.computeTransientFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.computeTransientFields();
    }

    private void computeTransientFields() {
        this.scale = 2.000000000007835 * this.\u0394fmod / (this.semiMajor * (1.0 - this.eccentricitySquared));
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
        while (--n3 >= 0) {
            double d = dArray2[++n2];
            double d2 = Math.sin(d);
            double d3 = Math.cos(d);
            double d4 = 1.0 - this.eccentricitySquared * (d2 * d2);
            d4 *= Math.sqrt(d4);
            dArray2[n2++] = d + this.scale * (d3 * d2) * d4;
        }
    }
}

