/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.opensearchserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.output.opensearchserver.OpenSearchServerConfig;
import org.apache.manifoldcf.agents.output.opensearchserver.OpenSearchServerConnection;
import org.apache.manifoldcf.core.common.Base64;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class OpenSearchServerIndex
extends OpenSearchServerConnection {
    protected static String[] convertACL(String[] acl, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException {
        if (acl != null) {
            String[] rval = new String[acl.length];
            for (int i = 0; i < rval.length; ++i) {
                rval[i] = activities.qualifyAccessToken(authorityNameString, acl[i]);
            }
            return rval;
        }
        return new String[0];
    }

    public OpenSearchServerIndex(HttpClient client, String documentURI, OpenSearchServerConfig config, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException {
        super(client, config);
        Acls acls = new Acls();
        Iterator a = document.securityTypesIterator();
        if (a != null) {
            while (a.hasNext()) {
                String securityType = (String)a.next();
                String[] convertedAcls = OpenSearchServerIndex.convertACL(document.getSecurityACL(securityType), authorityNameString, activities);
                String[] convertedDenyAcls = OpenSearchServerIndex.convertACL(document.getSecurityDenyACL(securityType), authorityNameString, activities);
                if (securityType.equals("document")) {
                    acls.setDocument(convertedAcls, convertedDenyAcls);
                    continue;
                }
                if (securityType.equals("share")) {
                    acls.setShare(convertedAcls, convertedDenyAcls);
                    continue;
                }
                this.setResult("UNKNOWNSECURITY", OpenSearchServerConnection.Result.ERROR, "Unhandled security type: " + securityType);
                return;
            }
        }
        StringBuffer url = this.getApiUrl("update");
        HttpPut put = new HttpPut(url.toString());
        put.setEntity((HttpEntity)new IndexRequestEntity(documentURI, document, acls));
        this.call((HttpRequestBase)put);
        if ("OK".equals(this.checkXPath(this.xPathStatus))) {
            return;
        }
        String error = this.checkXPath(this.xPathException);
        this.setResult("XPATHEXCEPTION", OpenSearchServerConnection.Result.ERROR, error);
        throw new ManifoldCFException("Error, unexpected response: " + error);
    }

    private static class IndexRequestEntity
    implements HttpEntity {
        private final String documentURI;
        private final RepositoryDocument document;
        private final String fileName;
        private final Acls acls;

        public IndexRequestEntity(String documentURI, RepositoryDocument document, Acls acls) {
            this.documentURI = documentURI;
            this.document = document;
            this.fileName = FilenameUtils.getName((String)documentURI);
            this.acls = acls;
        }

        public boolean isChunked() {
            return false;
        }

        @Deprecated
        public void consumeContent() throws IOException {
            EntityUtils.consume((HttpEntity)this);
        }

        public boolean isRepeatable() {
            return false;
        }

        public boolean isStreaming() {
            return true;
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            return null;
        }

        private static final void writeFieldCdata(String fieldName, Collection<String> values, PrintWriter pw) {
            if (CollectionUtils.isEmpty(values)) {
                return;
            }
            pw.print("<field name=\"");
            pw.print(StringEscapeUtils.escapeXml((String)fieldName));
            pw.print("\">");
            for (String value : values) {
                pw.print("<value><![CDATA[");
                pw.print(value);
                pw.print("]]></value>");
            }
            pw.println("</field>");
        }

        private static final void writeField(String fieldName, String value, PrintWriter pw) {
            if (StringUtils.isEmpty((String)value)) {
                return;
            }
            pw.print("<field name=\"");
            pw.print(fieldName);
            pw.print("\"><value>");
            pw.print(value);
            pw.println("</value></field>");
        }

        private static final void writeFieldValues(String fieldName, String[] values, PrintWriter pw) {
            if (values == null || values.length == 0) {
                return;
            }
            pw.print("<field name=\"");
            pw.print(fieldName);
            pw.println("\">");
            for (String value : values) {
                pw.print("<value>");
                pw.print(value);
                pw.println("</value>");
            }
            pw.println("</field>");
        }

        public void writeTo(OutputStream out) throws IOException {
            PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8), false);
            try {
                pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                pw.println("<index>);");
                pw.print("<document>");
                ArrayList<String> values = new ArrayList<String>(1);
                Iterator iter = this.document.getFields();
                if (iter != null) {
                    while (iter.hasNext()) {
                        Object[] fieldValues;
                        String fieldName = (String)iter.next();
                        if ("uri".equals(fieldName) || (fieldValues = this.document.getField(fieldName)) == null || fieldValues.length <= 0) continue;
                        values.clear();
                        for (Object fieldValue : fieldValues) {
                            if (fieldValue == null) continue;
                            values.add(fieldValue.toString());
                        }
                        IndexRequestEntity.writeFieldCdata(fieldName, values, pw);
                    }
                }
                IndexRequestEntity.writeField("uri", this.documentURI, pw);
                if (this.document.getBinaryLength() > 0L) {
                    Base64 base64 = new Base64();
                    pw.print("<binary fileName=\"");
                    pw.print(this.fileName);
                    pw.println("\">");
                    base64.encodeStream(this.document.getBinaryStream(), (Writer)pw);
                    pw.println("</binary>");
                }
                if (this.acls != null) {
                    IndexRequestEntity.writeFieldValues("userAllow", this.acls.acls, pw);
                    IndexRequestEntity.writeFieldValues("userDeny", this.acls.denyAcls, pw);
                    IndexRequestEntity.writeFieldValues("groupAllow", this.acls.shareAcls, pw);
                    IndexRequestEntity.writeFieldValues("groupDeny", this.acls.shareDenyAcls, pw);
                }
                pw.println("</document>");
                pw.println("</index>");
            }
            catch (ManifoldCFException e) {
                throw new IOException(e.getMessage(), e);
            }
            finally {
                IOUtils.closeQuietly((Writer)pw);
            }
        }

        public long getContentLength() {
            return -1L;
        }

        public Header getContentType() {
            return new BasicHeader("Content-type", "text/xml; charset=utf-8");
        }

        public Header getContentEncoding() {
            return null;
        }
    }

    private static class Acls {
        private String[] acls = null;
        private String[] denyAcls = null;
        private String[] shareAcls = null;
        private String[] shareDenyAcls = null;

        private Acls() {
        }

        private void setDocument(String[] acls, String[] denyAcls) {
            this.acls = acls;
            this.denyAcls = denyAcls;
        }

        private void setShare(String[] acls, String[] denyAcls) {
            this.shareAcls = acls;
            this.shareDenyAcls = denyAcls;
        }
    }
}

