/*
 * Decompiled with CFR 0.152.
 */
package org.noggit;

import java.io.IOException;
import java.io.Writer;
import org.noggit.CharArr;

class CharArrWriter
extends CharArr {
    protected Writer sink;

    CharArrWriter() {
    }

    @Override
    public void flush() {
        try {
            this.sink.write(this.buf, this.start, this.end - this.start);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.end = 0;
        this.start = 0;
    }

    @Override
    public void write(char b) {
        if (this.end >= this.buf.length) {
            this.flush();
        }
        this.unsafeWrite(b);
    }

    @Override
    public void write(char[] b, int off, int len) {
        int space = this.buf.length - this.end;
        if (len < space) {
            this.unsafeWrite(b, off, len);
        } else if (len < this.buf.length) {
            this.unsafeWrite(b, off, space);
            this.flush();
            this.unsafeWrite(b, off + space, len - space);
        } else {
            this.flush();
            try {
                this.sink.write(b, off, len);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void write(String s, int stringOffset, int len) {
        int space = this.buf.length - this.end;
        if (len < space) {
            s.getChars(stringOffset, stringOffset + len, this.buf, this.end);
            this.end += len;
        } else if (len < this.buf.length) {
            s.getChars(stringOffset, stringOffset + space, this.buf, this.end);
            this.flush();
            s.getChars(stringOffset + space, stringOffset + len, this.buf, 0);
            this.end = len - space;
        } else {
            this.flush();
            try {
                this.sink.write(s, stringOffset, len);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

