/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.script.AbstractFloatSearchScript;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.NativeScriptFactory;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;

public class ScriptService
extends AbstractComponent {
    private final String defaultLang;
    private final ImmutableMap<String, ScriptEngineService> scriptEngines;
    private final ConcurrentMap<String, CompiledScript> staticCache = ConcurrentCollections.newConcurrentMap();
    private final Cache<CacheKey, CompiledScript> cache;
    private final File scriptsDirectory;
    private final boolean disableDynamic;

    @Inject
    public ScriptService(Settings settings, Environment env, Set<ScriptEngineService> scriptEngines, ResourceWatcherService resourceWatcherService) {
        super(settings);
        int cacheMaxSize = this.componentSettings.getAsInt("cache.max_size", (Integer)500);
        TimeValue cacheExpire = this.componentSettings.getAsTime("cache.expire", null);
        this.logger.debug("using script cache with max_size [{}], expire [{}]", cacheMaxSize, cacheExpire);
        this.defaultLang = this.componentSettings.get("default_lang", "mvel");
        this.disableDynamic = this.componentSettings.getAsBoolean("disable_dynamic", (Boolean)false);
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder();
        if (cacheMaxSize >= 0) {
            cacheBuilder.maximumSize(cacheMaxSize);
        }
        if (cacheExpire != null) {
            cacheBuilder.expireAfterAccess(cacheExpire.nanos(), TimeUnit.NANOSECONDS);
        }
        this.cache = cacheBuilder.build();
        ImmutableMap.Builder<String, ScriptEngineService> builder = ImmutableMap.builder();
        for (ScriptEngineService scriptEngine : scriptEngines) {
            for (String type : scriptEngine.types()) {
                builder.put(type, scriptEngine);
            }
        }
        this.scriptEngines = builder.build();
        this.staticCache.put("doc.score", new CompiledScript("native", new DocScoreNativeScriptFactory()));
        this.scriptsDirectory = new File(env.configFile(), "scripts");
        FileWatcher fileWatcher = new FileWatcher(this.scriptsDirectory);
        fileWatcher.addListener(new ScriptChangesListener());
        if (this.componentSettings.getAsBoolean("auto_reload_enabled", (Boolean)true).booleanValue()) {
            resourceWatcherService.add(fileWatcher);
        } else {
            fileWatcher.init();
        }
    }

    public void close() {
        for (ScriptEngineService engineService : this.scriptEngines.values()) {
            engineService.close();
        }
    }

    public CompiledScript compile(String script) {
        return this.compile(this.defaultLang, script);
    }

    public CompiledScript compile(String lang, String script) {
        CompiledScript compiled = (CompiledScript)this.staticCache.get(script);
        if (compiled != null) {
            return compiled;
        }
        if (lang == null) {
            lang = this.defaultLang;
        }
        if (this.dynamicScriptDisabled(lang)) {
            throw new ScriptException("dynamic scripting disabled");
        }
        CacheKey cacheKey = new CacheKey(lang, script);
        compiled = this.cache.getIfPresent(cacheKey);
        if (compiled != null) {
            return compiled;
        }
        ScriptEngineService service = this.scriptEngines.get(lang);
        if (service == null) {
            throw new ElasticsearchIllegalArgumentException("script_lang not supported [" + lang + "]");
        }
        compiled = new CompiledScript(lang, service.compile(script));
        this.cache.put(cacheKey, compiled);
        return compiled;
    }

    public ExecutableScript executable(String lang, String script, Map vars) {
        return this.executable(this.compile(lang, script), vars);
    }

    public ExecutableScript executable(CompiledScript compiledScript, Map vars) {
        return this.scriptEngines.get(compiledScript.lang()).executable(compiledScript.compiled(), vars);
    }

    public SearchScript search(CompiledScript compiledScript, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        return this.scriptEngines.get(compiledScript.lang()).search(compiledScript.compiled(), lookup, vars);
    }

    public SearchScript search(SearchLookup lookup, String lang, String script, @Nullable Map<String, Object> vars) {
        return this.search(this.compile(lang, script), lookup, vars);
    }

    public SearchScript search(MapperService mapperService, IndexFieldDataService fieldDataService, String lang, String script, @Nullable Map<String, Object> vars) {
        return this.search(this.compile(lang, script), new SearchLookup(mapperService, fieldDataService, null), vars);
    }

    public Object execute(CompiledScript compiledScript, Map vars) {
        return this.scriptEngines.get(compiledScript.lang()).execute(compiledScript.compiled(), vars);
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    private boolean dynamicScriptDisabled(String lang) {
        if (!this.disableDynamic) {
            return false;
        }
        return !"native".equals(lang);
    }

    public static class DocScoreSearchScript
    extends AbstractFloatSearchScript {
        @Override
        public float runAsFloat() {
            try {
                return this.doc().score();
            }
            catch (IOException e) {
                return 0.0f;
            }
        }
    }

    public static class DocScoreNativeScriptFactory
    implements NativeScriptFactory {
        @Override
        public ExecutableScript newScript(@Nullable Map<String, Object> params) {
            return new DocScoreSearchScript();
        }
    }

    public static class CacheKey {
        public final String lang;
        public final String script;

        public CacheKey(String lang, String script) {
            this.lang = lang;
            this.script = script;
        }

        public boolean equals(Object o) {
            CacheKey other = (CacheKey)o;
            return this.lang.equals(other.lang) && this.script.equals(other.script);
        }

        public int hashCode() {
            return this.lang.hashCode() + 31 * this.script.hashCode();
        }
    }

    private class ScriptChangesListener
    extends FileChangesListener {
        private ScriptChangesListener() {
        }

        private Tuple<String, String> scriptNameExt(File file) {
            String scriptPath = ScriptService.this.scriptsDirectory.toURI().relativize(file.toURI()).getPath();
            int extIndex = scriptPath.lastIndexOf(46);
            if (extIndex != -1) {
                String ext = scriptPath.substring(extIndex + 1);
                String scriptName = scriptPath.substring(0, extIndex).replace(File.separatorChar, '_');
                return new Tuple<String, String>(scriptName, ext);
            }
            return null;
        }

        @Override
        public void onFileInit(File file) {
            Tuple<String, String> scriptNameExt = this.scriptNameExt(file);
            if (scriptNameExt != null) {
                boolean found = false;
                for (ScriptEngineService engineService : ScriptService.this.scriptEngines.values()) {
                    for (String s : engineService.extensions()) {
                        if (!s.equals(scriptNameExt.v2())) continue;
                        found = true;
                        try {
                            ScriptService.this.logger.trace("compiling script file " + file.getAbsolutePath(), new Object[0]);
                            String script = Streams.copyToString(new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8));
                            ScriptService.this.staticCache.put(scriptNameExt.v1(), new CompiledScript(engineService.types()[0], engineService.compile(script)));
                        }
                        catch (Throwable e) {
                            ScriptService.this.logger.warn("failed to load/compile script [{}]", e, scriptNameExt.v1());
                        }
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (!found) {
                    ScriptService.this.logger.warn("no script engine found for [{}]", scriptNameExt.v2());
                }
            }
        }

        @Override
        public void onFileCreated(File file) {
            this.onFileInit(file);
        }

        @Override
        public void onFileDeleted(File file) {
            Tuple<String, String> scriptNameExt = this.scriptNameExt(file);
            ScriptService.this.logger.trace("removing script file " + file.getAbsolutePath(), new Object[0]);
            ScriptService.this.staticCache.remove(scriptNameExt.v1());
        }

        @Override
        public void onFileChanged(File file) {
            this.onFileInit(file);
        }
    }
}

