/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.dblook;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import org.apache.derby.impl.tools.dblook.Logs;
import org.apache.derby.tools.dblook;

public class DB_GrantRevoke {
    public static void doAuthorizations(Connection connection, boolean bl) throws SQLException {
        ResultSet resultSet;
        Statement statement = connection.createStatement();
        if (bl) {
            resultSet = statement.executeQuery("SELECT P.GRANTEE, S.SCHEMANAME, A.ALIAS, P.PERMISSION, P.OBJECTTYPE FROM SYS.SYSPERMS P, SYS.SYSALIASES A, SYS.SYSSCHEMAS S WHERE A.SCHEMAID = S.SCHEMAID AND P.OBJECTID = A.ALIASID AND A.ALIASTYPE='A'");
            DB_GrantRevoke.generateUDTPrivs(resultSet);
            resultSet = statement.executeQuery("SELECT P.GRANTEE, S.SCHEMANAME, SEQ.SEQUENCENAME, P.PERMISSION, P.OBJECTTYPE FROM SYS.SYSPERMS P, SYS.SYSSEQUENCES SEQ, SYS.SYSSCHEMAS S WHERE SEQ.SCHEMAID = S.SCHEMAID AND P.OBJECTID = SEQ.SEQUENCEID");
            DB_GrantRevoke.generateSequencePrivs(resultSet);
            resultSet = statement.executeQuery("SELECT P.GRANTEE, S.SCHEMANAME, A.ALIAS, P.PERMISSION, P.OBJECTTYPE FROM SYS.SYSPERMS P, SYS.SYSALIASES A, SYS.SYSSCHEMAS S WHERE A.SCHEMAID = S.SCHEMAID AND P.OBJECTID = A.ALIASID AND A.ALIASTYPE='G'");
            DB_GrantRevoke.generateAggregatePrivs(resultSet);
        }
        resultSet = statement.executeQuery("SELECT GRANTEE, SCHEMANAME, TABLENAME, SELECTPRIV, DELETEPRIV, INSERTPRIV, UPDATEPRIV, REFERENCESPRIV, TRIGGERPRIV FROM SYS.SYSTABLEPERMS P, SYS.SYSTABLES T, SYS.SYSSCHEMAS S WHERE T.SCHEMAID = S.SCHEMAID AND T.TABLEID = P.TABLEID");
        DB_GrantRevoke.generateTablePrivs(resultSet);
        resultSet = statement.executeQuery("SELECT GRANTEE, SCHEMANAME, TABLENAME, TYPE, COLUMNS FROM SYS.SYSCOLPERMS P, SYS.SYSTABLES T, SYS.SYSSCHEMAS S WHERE T.SCHEMAID = S.SCHEMAID AND T.TABLEID = P.TABLEID");
        DB_GrantRevoke.generateColumnPrivs(resultSet, connection);
        resultSet = statement.executeQuery("SELECT GRANTEE, SCHEMANAME, ALIAS, ALIASTYPE FROM SYS.SYSROUTINEPERMS P, SYS.SYSALIASES A, SYS.SYSSCHEMAS S WHERE A.SCHEMAID = S.SCHEMAID AND P.ALIASID = A.ALIASID");
        DB_GrantRevoke.generateRoutinePrivs(resultSet);
        resultSet.close();
        statement.close();
    }

    private static void generateTablePrivs(ResultSet resultSet) throws SQLException {
        boolean bl = true;
        while (resultSet.next()) {
            if (bl) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_TablePrivHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            String string = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(1)));
            String string2 = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(2)));
            String string3 = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(3)));
            String string4 = string2 + "." + string3;
            if (dblook.isIgnorableSchema(string2)) continue;
            Logs.writeToNewDDL(DB_GrantRevoke.tablePrivStatement(resultSet, string4, string));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            bl = false;
        }
    }

    private static String separatorStr(boolean bl) {
        return bl ? ", " : "";
    }

    private static String tablePrivStatement(ResultSet resultSet, String string, String string2) throws SQLException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("GRANT ");
        if (resultSet.getString(4).toUpperCase().equals("Y")) {
            stringBuffer.append("SELECT");
            bl = true;
        }
        if (resultSet.getString(5).toUpperCase().equals("Y")) {
            stringBuffer.append(DB_GrantRevoke.separatorStr(bl) + "DELETE");
            bl = true;
        }
        if (resultSet.getString(6).toUpperCase().equals("Y")) {
            stringBuffer.append(DB_GrantRevoke.separatorStr(bl) + "INSERT");
            bl = true;
        }
        if (resultSet.getString(7).toUpperCase().equals("Y")) {
            stringBuffer.append(DB_GrantRevoke.separatorStr(bl) + "UPDATE");
            bl = true;
        }
        if (resultSet.getString(8).toUpperCase().equals("Y")) {
            stringBuffer.append(DB_GrantRevoke.separatorStr(bl) + "REFERENCES");
            bl = true;
        }
        if (resultSet.getString(9).toUpperCase().equals("Y")) {
            stringBuffer.append(DB_GrantRevoke.separatorStr(bl) + "TRIGGER");
            bl = true;
        }
        stringBuffer.append(" ON " + string + " TO " + string2);
        return stringBuffer.toString();
    }

    private static void generateColumnPrivs(ResultSet resultSet, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT COLUMNNUMBER, COLUMNNAME FROM SYS.SYSCOLUMNS C, SYS.SYSTABLES T, SYS.SYSSCHEMAS S WHERE T.TABLEID = C.REFERENCEID and S.SCHEMAID = T.SCHEMAID AND S.SCHEMANAME = ? AND T.TABLENAME = ? ORDER BY COLUMNNUMBER");
        boolean bl = true;
        while (resultSet.next()) {
            if (bl) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_ColumnPrivHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            String string = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(1)));
            String string2 = resultSet.getString(2);
            String string3 = resultSet.getString(3);
            String string4 = dblook.addQuotes(dblook.expandDoubleQuotes(string2));
            if (dblook.isIgnorableSchema(string4)) continue;
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string3);
            ResultSet resultSet2 = preparedStatement.executeQuery();
            String string5 = string4 + "." + dblook.addQuotes(dblook.expandDoubleQuotes(string3));
            Logs.writeToNewDDL(DB_GrantRevoke.columnPrivStatement(resultSet, string5, string, resultSet2));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            bl = false;
            resultSet2.close();
        }
        preparedStatement.close();
    }

    private static String privTypeToString(String string) {
        if (string.equals("S")) {
            return "SELECT";
        }
        if (string.equals("R")) {
            return "REFERENCES";
        }
        if (string.equals("U")) {
            return "UPDATE";
        }
        return "";
    }

    private static String mapColumnsToNames(String string, ResultSet resultSet) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        resultSet.next();
        int n = 1;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,{}");
        while (stringTokenizer.hasMoreTokens()) {
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            while (n2 + 1 > n) {
                resultSet.next();
                n = resultSet.getInt(1);
            }
            stringBuffer.append(DB_GrantRevoke.separatorStr(bl));
            bl = true;
            String string2 = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(2)));
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private static String columnPrivStatement(ResultSet resultSet, String string, String string2, ResultSet resultSet2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("GRANT ");
        String string3 = resultSet.getString(4).toUpperCase();
        String string4 = resultSet.getString(5);
        stringBuffer.append(DB_GrantRevoke.privTypeToString(string3));
        stringBuffer.append("(");
        stringBuffer.append(DB_GrantRevoke.mapColumnsToNames(string4, resultSet2));
        stringBuffer.append(") ON ");
        stringBuffer.append(string);
        stringBuffer.append(" TO ");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static void generateUDTPrivs(ResultSet resultSet) throws SQLException {
        boolean bl = true;
        while (resultSet.next()) {
            String string = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(1)));
            String string2 = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(2)));
            String string3 = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(3)));
            String string4 = string2 + "." + string3;
            String string5 = resultSet.getString(4);
            String string6 = resultSet.getString(5);
            if (dblook.isIgnorableSchema(string2)) continue;
            if (bl) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_UDTPrivHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            Logs.writeToNewDDL(DB_GrantRevoke.genericPrivStatement(string4, string, string5, string6));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            bl = false;
        }
    }

    public static void generateSequencePrivs(ResultSet resultSet) throws SQLException {
        boolean bl = true;
        while (resultSet.next()) {
            String string = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(1)));
            String string2 = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(2)));
            String string3 = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(3)));
            String string4 = string2 + "." + string3;
            String string5 = resultSet.getString(4);
            String string6 = resultSet.getString(5);
            if (dblook.isIgnorableSchema(string2)) continue;
            if (bl) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_SequencePrivHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            Logs.writeToNewDDL(DB_GrantRevoke.genericPrivStatement(string4, string, string5, string6));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            bl = false;
        }
    }

    public static void generateAggregatePrivs(ResultSet resultSet) throws SQLException {
        boolean bl = true;
        while (resultSet.next()) {
            String string = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(1)));
            String string2 = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(2)));
            String string3 = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(3)));
            String string4 = string2 + "." + string3;
            String string5 = resultSet.getString(4);
            String string6 = resultSet.getString(5);
            if (dblook.isIgnorableSchema(string2)) continue;
            if (bl) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_AggregatePrivHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            Logs.writeToNewDDL(DB_GrantRevoke.genericPrivStatement(string4, string, string5, string6));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            bl = false;
        }
    }

    private static String genericPrivStatement(String string, String string2, String string3, String string4) throws SQLException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("GRANT " + string3 + " ON " + string4 + " ");
        stringBuffer.append(string);
        stringBuffer.append(" TO ");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static void generateRoutinePrivs(ResultSet resultSet) throws SQLException {
        boolean bl = true;
        while (resultSet.next()) {
            String string = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(1)));
            String string2 = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(2)));
            String string3 = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(3)));
            String string4 = string2 + "." + string3;
            String string5 = resultSet.getString(4);
            if (dblook.isIgnorableSchema(string2) || string2.equals("\"SYSCS_UTIL\"")) continue;
            if (bl) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_RoutinePrivHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            Logs.writeToNewDDL(DB_GrantRevoke.routinePrivStatement(string4, string, string5));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            bl = false;
        }
    }

    private static String routinePrivStatement(String string, String string2, String string3) throws SQLException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("GRANT EXECUTE ON ");
        stringBuffer.append(string3.equals("P") ? "PROCEDURE " : "FUNCTION ");
        stringBuffer.append(string);
        stringBuffer.append(" TO ");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }
}

